"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerMapExtension = registerMapExtension;
var _anomaly_source_factory = require("./anomaly_source_factory");
var _anomaly_layer_wizard_factory = require("./anomaly_layer_wizard_factory");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function registerMapExtension(mapsSetupApi, core, {
  canGetJobs,
  canCreateJobs
}) {
  const anomalySourceFactory = new _anomaly_source_factory.AnomalySourceFactory(core.getStartServices);
  const anomalyLayerWizardFactory = new _anomaly_layer_wizard_factory.AnomalyLayerWizardFactory(core.getStartServices, canGetJobs, canCreateJobs);
  const anomalylayerWizard = await anomalyLayerWizardFactory.create();
  mapsSetupApi.registerSource({
    type: anomalySourceFactory.type,
    ConstructorFunction: await anomalySourceFactory.create()
  });
  mapsSetupApi.registerLayerWizard(anomalylayerWizard);
}