"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.trainedModelsEbtEvents = void 0;
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const trainedModelsDeploymentSchema = {
  model_id: {
    type: 'keyword',
    _meta: {
      description: 'The ID of the trained model'
    }
  },
  optimized: {
    type: 'keyword',
    _meta: {
      description: 'The optimized setting of the deployment'
    }
  },
  adaptive_resources: {
    type: 'boolean',
    _meta: {
      description: 'Whether adaptive resources are enabled'
    }
  },
  vcpu_usage: {
    type: 'keyword',
    _meta: {
      description: 'The vCPU/VCU usage level'
    }
  },
  number_of_allocations: {
    type: 'integer',
    _meta: {
      description: 'The number of allocations',
      optional: true
    }
  },
  threads_per_allocation: {
    type: 'integer',
    _meta: {
      description: 'The number of threads per allocation'
    }
  },
  min_number_of_allocations: {
    type: 'integer',
    _meta: {
      description: 'The minimum number of allocations',
      optional: true
    }
  },
  max_number_of_allocations: {
    type: 'integer',
    _meta: {
      description: 'The maximum number of allocations',
      optional: true
    }
  },
  result: {
    type: 'keyword',
    _meta: {
      description: 'The result of the deployment'
    }
  }
};
const trainedModelsModelDownloadSchema = {
  model_id: {
    type: 'keyword',
    _meta: {
      description: 'The ID of the trained model'
    }
  },
  result: {
    type: 'keyword',
    _meta: {
      description: 'The result of the model download'
    }
  }
};
const trainedModelsModelTestedSchema = {
  model_id: {
    type: 'keyword',
    _meta: {
      description: 'The ID of the trained model'
    }
  },
  model_type: {
    type: 'keyword',
    _meta: {
      description: 'The type of the trained model',
      optional: true
    }
  },
  task_type: {
    type: 'keyword',
    _meta: {
      description: 'The type of the task',
      optional: true
    }
  },
  result: {
    type: 'keyword',
    _meta: {
      description: 'The result of the task'
    }
  }
};
const trainedModelsDeploymentCreatedEventType = {
  eventType: _types.TrainedModelsTelemetryEventTypes.DEPLOYMENT_CREATED,
  schema: trainedModelsDeploymentSchema
};
const trainedModelsModelDownloadEventType = {
  eventType: _types.TrainedModelsTelemetryEventTypes.MODEL_DOWNLOAD,
  schema: trainedModelsModelDownloadSchema
};
const trainedModelsDeploymentUpdatedEventType = {
  eventType: _types.TrainedModelsTelemetryEventTypes.DEPLOYMENT_UPDATED,
  schema: trainedModelsDeploymentSchema
};
const trainedModelsModelTestedEventType = {
  eventType: _types.TrainedModelsTelemetryEventTypes.MODEL_TESTED,
  schema: trainedModelsModelTestedSchema
};
const trainedModelsEbtEvents = exports.trainedModelsEbtEvents = {
  trainedModelsDeploymentCreatedEventType,
  trainedModelsModelDownloadEventType,
  trainedModelsDeploymentUpdatedEventType,
  trainedModelsModelTestedEventType
};