"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataVisualizerGrid = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _overview_ml_page = require("./overview_ml_page");
var _locator = require("../../locator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DataVisualizerGrid = ({
  buttonType,
  isEsqlEnabled
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
  gutterSize: "m",
  columns: 2
}, isEsqlEnabled ? /*#__PURE__*/_react.default.createElement(_overview_ml_page.MLOverviewCard, {
  layout: "horizontal",
  path: _locator.ML_PAGES.DATA_VISUALIZER_ESQL,
  title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.datavisualizer.selector.selectESQLTitle",
    defaultMessage: "ES|QL"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: "",
    iconType: "beaker",
    size: "m",
    color: "hollow",
    tooltipContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.datavisualizer.selector.esqlTechnicalPreviewBadge.titleMsg",
      defaultMessage: "ES|QL data visualizer is in technical preview."
    }),
    tooltipPosition: 'right'
  }))),
  description: _i18n.i18n.translate('xpack.ml.datavisualizer.selector.technicalPreviewBadge.contentMsg', {
    defaultMessage: 'The Elasticsearch Query Language (ES|QL) provides a powerful way to filter, transform, and analyze data stored in Elasticsearch.'
  }),
  iconType: "esqlVis",
  buttonLabel: _i18n.i18n.translate('xpack.ml.datavisualizer.selector.tryESQLNowButtonLabel', {
    defaultMessage: 'Try it now!'
  }),
  cardDataTestSubj: "mlDataVisualizerSelectESQLCard",
  buttonDataTestSubj: "mlDataVisualizerSelectESQLButton",
  buttonType: buttonType
}) : null, /*#__PURE__*/_react.default.createElement(_overview_ml_page.MLOverviewCard, {
  layout: "horizontal",
  path: "/filedatavisualizer",
  title: _i18n.i18n.translate('xpack.ml.datavisualizer.selector.importDataTitle', {
    defaultMessage: 'Visualize data from a file'
  }),
  description: _i18n.i18n.translate('xpack.ml.datavisualizer.selector.importDataDescription', {
    defaultMessage: 'Upload your file, analyze its data, and optionally import the data into an index.'
  }),
  iconType: "addDataApp",
  buttonLabel: _i18n.i18n.translate('xpack.ml.datavisualizer.selector.uploadFileButtonLabel', {
    defaultMessage: 'Select file'
  }),
  cardDataTestSubj: "mlDataVisualizerCardImportData",
  buttonDataTestSubj: "mlDataVisualizerUploadFileButton",
  buttonType: buttonType
}), /*#__PURE__*/_react.default.createElement(_overview_ml_page.MLOverviewCard, {
  layout: "horizontal",
  path: "/datavisualizer_index_select",
  title: _i18n.i18n.translate('xpack.ml.datavisualizer.selector.selectDataViewTitle', {
    defaultMessage: 'Visualize data from a data view'
  }),
  description: _i18n.i18n.translate('xpack.ml.datavisualizer.selector.selectDataViewTitle', {
    defaultMessage: 'Analyze data, its shape, and statistical metadata from a data view.'
  }),
  iconType: "dataVisualizer",
  buttonLabel: _i18n.i18n.translate('xpack.ml.datavisualizer.selector.selectDataViewButtonLabel', {
    defaultMessage: 'Select data view'
  }),
  cardDataTestSubj: "mlDataVisualizerCardIndexData",
  buttonDataTestSubj: "mlDataVisualizerSelectIndexButton",
  buttonType: buttonType
}), /*#__PURE__*/_react.default.createElement(_overview_ml_page.MLOverviewCard, {
  layout: "horizontal",
  path: "/data_drift_index_select",
  title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.datavisualizer.selector.selectDataDriftTitle",
    defaultMessage: "Visualize data using data drift"
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: "",
    iconType: "beaker",
    size: "m",
    color: "hollow",
    tooltipContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.datavisualizer.selector.dataDriftTechnicalPreviewBadge.titleMsg",
      defaultMessage: "Data drift visualizer is in technical preview."
    }),
    tooltipPosition: 'right'
  })),
  description: _i18n.i18n.translate('xpack.ml.datavisualizer.selector.dataDriftDescription', {
    defaultMessage: 'Detecting data drifts enables you to identify potential performance issues.'
  }),
  iconType: "visTagCloud",
  buttonLabel: _i18n.i18n.translate('xpack.ml.datavisualizer.selector.selectDataViewButtonLabel', {
    defaultMessage: 'Compare data distribution'
  }),
  cardDataTestSubj: "mlDataVisualizerCardDataDriftData",
  buttonDataTestSubj: "mlDataVisualizerSelectDataDriftButton",
  buttonType: buttonType
}));
exports.DataVisualizerGrid = DataVisualizerGrid;