"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StartDatafeedSwitch = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StartDatafeedSwitch = ({
  startDatafeed,
  setStartDatafeed,
  disabled = false
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    helpText: _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.startDatafeedCheckboxHelpText', {
      defaultMessage: 'If unselected, job can be started later from the jobs list.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "mlJobWizardStartDatafeedCheckbox",
    label: _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.startDatafeedCheckbox', {
      defaultMessage: 'Start immediately'
    }),
    checked: startDatafeed,
    onChange: e => setStartDatafeed(e.target.checked),
    disabled: disabled
  })));
};
exports.StartDatafeedSwitch = StartDatafeedSwitch;