"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PointVisibilityOption = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/expression-xy-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const pointVisibilityOptions = [{
  id: `xy_point_visibility_auto`,
  value: _public.PointVisibilityOptions.AUTO,
  label: _i18n.i18n.translate('xpack.lens.xy.pointVisibility.auto', {
    defaultMessage: 'Auto'
  })
}, {
  id: `xy_point_visibility_show`,
  value: _public.PointVisibilityOptions.ALWAYS,
  label: _i18n.i18n.translate('xpack.lens.xy.pointVisibility.show', {
    defaultMessage: 'Show'
  })
}, {
  id: `xy_point_visibility_hide`,
  value: _public.PointVisibilityOptions.NEVER,
  label: _i18n.i18n.translate('xpack.lens.xy.pointVisibility.hide', {
    defaultMessage: 'Hide'
  })
}];
const PointVisibilityOption = ({
  enabled = true,
  selectedPointVisibility = _public.PointVisibilityOptions.AUTO,
  onChange
}) => {
  return enabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.xyChart.pointVisibilityLabel', {
      defaultMessage: 'Point visibility'
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    legend: _i18n.i18n.translate('xpack.lens.xyChart.pointVisibilityLabel', {
      defaultMessage: 'Point visibility'
    }),
    "data-test-subj": "lnsPointVisibilityOption",
    buttonSize: "compressed",
    options: pointVisibilityOptions,
    idSelected: pointVisibilityOptions.find(({
      value
    }) => value === selectedPointVisibility).id,
    onChange: pointVisibilityId => {
      const newPointVisibility = pointVisibilityOptions.find(({
        id
      }) => id === pointVisibilityId);
      if (newPointVisibility) {
        onChange(newPointVisibility.value);
      }
    }
  })) : null;
};
exports.PointVisibilityOption = PointVisibilityOption;