"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUsedDataViews = getUsedDataViews;
var _lodash = require("lodash");
var _utils = require("../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getUsedDataViews(references, adHocDataViewsSpecs, dataViews) {
  const [{
    indexPatterns
  }, ...adHocDataViews] = await Promise.all([(0, _utils.getIndexPatternsObjects)(
  // get index pattern only references
  references.filter(({
    type
  }) => type === 'index-pattern').map(({
    id
  }) => id), dataViews), ...Object.values(adHocDataViewsSpecs !== null && adHocDataViewsSpecs !== void 0 ? adHocDataViewsSpecs : {}).map(spec => dataViews.create(spec))]);
  return (0, _lodash.uniqBy)(indexPatterns.concat(adHocDataViews), 'id');
}