"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoDataPage = exports.NO_DATA_RECOMMENDED = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _classnames = _interopRequireDefault(require("classnames"));
var _no_data_card = require("./no_data_card");
var _no_data_page_body = require("./no_data_page_body/no_data_page_body");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const NO_DATA_RECOMMENDED = exports.NO_DATA_RECOMMENDED = _i18n.i18n.translate('kibana-react.noDataPage.noDataPage.recommended', {
  defaultMessage: 'Recommended'
});
const NoDataPage = ({
  solution,
  logo,
  actions,
  docsLink,
  pageTitle,
  ...rest
}) => {
  // Convert obj data into an iterable array
  const entries = Object.entries(actions);

  // This sort fn may look nonsensical, but it's some Good Ol' Javascript (TM)
  // Sort functions want either a 1, 0, or -1 returned to determine order,
  // and it turns out in JS you CAN minus booleans from each other to get a 1, 0, or -1 - e.g., (true - false == 1) :whoa:
  const sortedEntries = entries.sort(([, firstObj], [, secondObj]) => {
    var _secondObj$recommende, _firstObj$recommended;
    // The `??` fallbacks are because the recommended key can be missing or undefined
    return Number((_secondObj$recommende = secondObj.recommended) !== null && _secondObj$recommende !== void 0 ? _secondObj$recommende : false) - Number((_firstObj$recommended = firstObj.recommended) !== null && _firstObj$recommended !== void 0 ? _firstObj$recommended : false);
  });

  // Convert the iterated [[key, value]] array format back into an object
  const sortedData = Object.fromEntries(sortedEntries);
  const actionsKeys = Object.keys(sortedData);
  const actionCards = (0, _react.useMemo)(() => {
    return Object.values(sortedData).map((action, i) => {
      const isAgent = actionsKeys[i] === 'elasticAgent' || actionsKeys[i] === 'beats';
      const key = isAgent ? 'empty-page-agent-action' : `empty-page-${actionsKeys[i]}-action`;
      return isAgent ? /*#__PURE__*/_react.default.createElement(_no_data_card.ElasticAgentCard, (0, _extends2.default)({
        key: key,
        solution: solution
      }, action)) : /*#__PURE__*/_react.default.createElement(_no_data_card.NoDataCard, (0, _extends2.default)({
        key: key
      }, action));
    });
  }, [actions, sortedData, actionsKeys]);
  const title = pageTitle || _i18n.i18n.translate('kibana-react.noDataPage.welcomeTitle', {
    defaultMessage: 'Welcome to Elastic {solution}!',
    values: {
      solution
    }
  });
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({}, rest, {
    className: (0, _classnames.default)('kbnNoDataPageContents', rest.className)
  }), /*#__PURE__*/_react.default.createElement(_no_data_page_body.NoDataPageBody, {
    pageTitle: title,
    actionCards: actionCards,
    logo: logo,
    solution: solution,
    docsLink: docsLink
  }), actionsKeys.length > 1 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "center",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "kibana-react.noDataPage.cantDecide",
    defaultMessage: "Confused on which to use? {link}",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://www.elastic.co/guide/en/fleet/current/beats-agent-comparison.html"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "kibana-react.noDataPage.cantDecide.link",
        defaultMessage: "Check our docs for more information."
      }))
    }
  })))) : undefined);
};
exports.NoDataPage = NoDataPage;