"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsExplorerChartContextMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _public = require("@kbn/observability-shared-plugin/public");
var _public2 = require("@kbn/metrics-data-access-plugin/public");
var _metrics_source = require("../../../../containers/metrics_source");
var _alert_flyout = require("../../../../alerting/metric_threshold/components/alert_flyout");
var _create_tsvb_link = require("./helpers/create_tsvb_link");
var _constants = require("../../../../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fieldToNodeType = groupBy => {
  const fields = Array.isArray(groupBy) ? groupBy : [groupBy];
  if (fields.includes(_constants.HOST_NAME_FIELD)) {
    return 'host';
  }
  if (fields.includes(_constants.KUBERNETES_POD_UID_FIELD)) {
    return 'pod';
  }
  if (fields.includes(_constants.CONTAINER_ID_FIELD)) {
    return 'container';
  }
};
const dateMathExpressionToEpoch = (dateMathExpression, roundUp = false) => {
  const dateObj = _datemath.default.parse(dateMathExpression, {
    roundUp
  });
  if (!dateObj) throw new Error(`"${dateMathExpression}" is not a valid time string`);
  return dateObj.valueOf();
};
const MetricsExplorerChartContextMenu = ({
  onFilter,
  options,
  series,
  timeRange,
  uiCapabilities,
  chartOptions
}) => {
  var _metricsView$indices, _uiCapabilities$visua, _uiCapabilities$infra;
  const {
    getAssetDetailUrl
  } = (0, _public2.useAssetDetailsRedirect)();
  const [isPopoverOpen, setPopoverState] = (0, _react.useState)(false);
  const [flyoutVisible, setFlyoutVisible] = (0, _react.useState)(false);
  const {
    metricsView
  } = (0, _metrics_source.useMetricsDataViewContext)();
  const supportFiltering = options.groupBy != null && onFilter != null;
  const handleFilter = (0, _react.useCallback)(() => {
    // onFilter needs check for Typescript even though it's
    // covered by supportFiltering variable
    if (supportFiltering && onFilter) {
      if (Array.isArray(options.groupBy)) {
        onFilter(options.groupBy.map((field, index) => {
          var _series$keys;
          return `${field}: "${(_series$keys = series.keys) === null || _series$keys === void 0 ? void 0 : _series$keys[index]}"`;
        }).join(' and '));
      } else {
        onFilter(`${options.groupBy}: "${series.id}"`);
      }
    }
    setPopoverState(false);
  }, [supportFiltering, onFilter, options, series.keys, series.id]);

  // Only display the "Add Filter" option if it's supported
  const filterByItem = supportFiltering ? [{
    name: _i18n.i18n.translate('xpack.infra.metricsExplorer.filterByLabel', {
      defaultMessage: 'Add filter'
    }),
    icon: 'metricsApp',
    onClick: handleFilter,
    'data-test-subj': 'metricsExplorerAction-AddFilter'
  }] : [];
  const nodeType = options.groupBy && fieldToNodeType(options.groupBy);
  const nodeDetailLinkProps = nodeType ? getAssetDetailUrl({
    assetType: nodeType,
    assetId: series.id,
    search: {
      from: dateMathExpressionToEpoch(timeRange.from),
      to: dateMathExpressionToEpoch(timeRange.to, true)
    }
  }) : {};
  const tsvbLinkProps = (0, _public.useLinkProps)({
    ...(0, _create_tsvb_link.createTSVBLink)((_metricsView$indices = metricsView === null || metricsView === void 0 ? void 0 : metricsView.indices) !== null && _metricsView$indices !== void 0 ? _metricsView$indices : _create_tsvb_link.TSVB_WORKAROUND_INDEX_PATTERN, options, series, timeRange, chartOptions)
  });
  const viewNodeDetail = nodeType ? [{
    name: _i18n.i18n.translate('xpack.infra.metricsExplorer.viewNodeDetail', {
      defaultMessage: 'View metrics for {name}',
      values: {
        name: nodeType
      }
    }),
    icon: 'metricsApp',
    ...(nodeType ? nodeDetailLinkProps : {}),
    'data-test-subj': 'metricsExplorerAction-ViewNodeMetrics'
  }] : [];
  const openInVisualize = uiCapabilities !== null && uiCapabilities !== void 0 && (_uiCapabilities$visua = uiCapabilities.visualize_v2) !== null && _uiCapabilities$visua !== void 0 && _uiCapabilities$visua.show ? [{
    name: _i18n.i18n.translate('xpack.infra.metricsExplorer.openInTSVB', {
      defaultMessage: 'Open in Visualize'
    }),
    ...tsvbLinkProps,
    icon: 'visualizeApp',
    disabled: options.metrics.length === 0,
    'data-test-subj': 'metricsExplorerAction-OpenInTSVB'
  }] : [];
  const createAlert = uiCapabilities !== null && uiCapabilities !== void 0 && (_uiCapabilities$infra = uiCapabilities.infrastructure) !== null && _uiCapabilities$infra !== void 0 && _uiCapabilities$infra.save ? [{
    name: _i18n.i18n.translate('xpack.infra.metricsExplorer.alerts.createRuleButton', {
      defaultMessage: 'Create threshold rule'
    }),
    icon: 'bell',
    onClick() {
      setFlyoutVisible(true);
    }
  }] : [];
  const itemPanels = [...filterByItem, ...openInVisualize, ...viewNodeDetail, ...createAlert];

  // If there are no itemPanels then there is no reason to show the actions button.
  if (itemPanels.length === 0) return null;
  const panels = [{
    id: 0,
    title: 'Actions',
    items: itemPanels
  }];
  const handleClose = () => setPopoverState(false);
  const togglePopover = () => setPopoverState(currentIsOpen => !currentIsOpen);
  const actionAriaLabel = _i18n.i18n.translate('xpack.infra.metricsExplorer.actionsLabel.aria', {
    defaultMessage: 'Actions for {grouping}',
    values: {
      grouping: series.id
    }
  });
  const actionLabel = _i18n.i18n.translate('xpack.infra.metricsExplorer.actionsLabel.button', {
    defaultMessage: 'Actions'
  });
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "infraMetricsExplorerChartContextMenuButton",
    contentProps: {
      'aria-label': actionAriaLabel
    },
    onClick: togglePopover,
    size: "s",
    iconType: "arrowDown",
    iconSide: "right"
  }, actionLabel);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    closePopover: handleClose,
    id: `${series.id}-popover`,
    button: button,
    isOpen: isPopoverOpen,
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels
  }), /*#__PURE__*/_react.default.createElement(_alert_flyout.AlertFlyout, {
    series: series,
    options: options,
    setVisible: setFlyoutVisible,
    visible: flyoutVisible
  })));
};
exports.MetricsExplorerChartContextMenu = MetricsExplorerChartContextMenu;