"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogEntryCategoriesPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _log_analysis_setup = require("../../../components/logging/log_analysis_setup");
var _log_analysis = require("../../../containers/logs/log_analysis");
var _subscription_splash_content = require("../../../components/subscription_splash_content");
var _use_logs_breadcrumbs = require("../../../hooks/use_logs_breadcrumbs");
var _page_content = require("./page_content");
var _page_providers = require("./page_providers");
var _translations = require("../../../translations");
var _use_log_ml_job_id_formats_shim = require("../shared/use_log_ml_job_id_formats_shim");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogEntryCategoriesPage = () => {
  (0, _use_logs_breadcrumbs.useLogsBreadcrumbs)([{
    text: _translations.logCategoriesTitle
  }]);
  const {
    hasLogAnalysisReadCapabilities,
    hasLogAnalysisCapabilites
  } = (0, _log_analysis.useLogAnalysisCapabilitiesContext)();
  if (!hasLogAnalysisCapabilites) {
    return /*#__PURE__*/_react.default.createElement(_subscription_splash_content.SubscriptionSplashPage, {
      "data-test-subj": "logsLogEntryCategoriesPage",
      pageHeader: {
        pageTitle: _translations.logCategoriesTitle
      }
    });
  }
  if (!hasLogAnalysisReadCapabilities) {
    return /*#__PURE__*/_react.default.createElement(_page_content.CategoriesPageTemplate, {
      isEmptyState: true
    }, /*#__PURE__*/_react.default.createElement(_log_analysis_setup.MissingResultsPrivilegesPrompt, null));
  }
  return /*#__PURE__*/_react.default.createElement(_use_log_ml_job_id_formats_shim.LogMlJobIdFormatsShimProvider, null, /*#__PURE__*/_react.default.createElement(_page_providers.LogEntryCategoriesPageProviders, null, /*#__PURE__*/_react.default.createElement(_page_content.LogEntryCategoriesPageContent, null)));
};
exports.LogEntryCategoriesPage = LogEntryCategoriesPage;