"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cleanUpJobsAndDatafeeds = void 0;
var _log_analysis = require("../../../../common/log_analysis");
var _ml_cleanup = require("./api/ml_cleanup");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const cleanUpJobsAndDatafeeds = async (spaceId, logViewId, idFormat, jobTypes, fetch) => {
  try {
    await (0, _ml_cleanup.callStopDatafeeds)({
      spaceId,
      logViewId,
      idFormat,
      jobTypes
    }, fetch);
  } catch (err) {
    var _err$response;
    // Proceed only if datafeed has been deleted or didn't exist in the first place
    if ((err === null || err === void 0 ? void 0 : (_err$response = err.response) === null || _err$response === void 0 ? void 0 : _err$response.status) !== 404) {
      throw err;
    }
  }
  return await deleteJobs(spaceId, logViewId, idFormat, jobTypes, fetch);
};
exports.cleanUpJobsAndDatafeeds = cleanUpJobsAndDatafeeds;
const deleteJobs = async (spaceId, logViewId, idFormat, jobTypes, fetch) => {
  const deleteJobsResponse = await (0, _ml_cleanup.callDeleteJobs)({
    spaceId,
    logViewId,
    idFormat,
    jobTypes
  }, fetch);
  await waitUntilJobsAreDeleted(spaceId, logViewId, idFormat, jobTypes, fetch);
  return deleteJobsResponse;
};
const waitUntilJobsAreDeleted = async (spaceId, logViewId, idFormat, jobTypes, fetch) => {
  const moduleJobIds = jobTypes.map(jobType => (0, _log_analysis.getJobId)(spaceId, logViewId, idFormat, jobType));
  while (true) {
    const {
      jobs
    } = await (0, _ml_cleanup.callGetJobDeletionTasks)(fetch);
    const needToWait = jobs.flatMap(job => Object.keys(job)).some(jobId => moduleJobIds.includes(jobId));
    if (needToWait) {
      await timeout(1000);
    } else {
      return true;
    }
  }
};
const timeout = ms => new Promise(res => setTimeout(res, ms));