"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetadataSummaryListCompact = exports.MetadataSummaryList = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _translations = require("../../../translations");
var _use_tab_switcher = require("../../../hooks/use_tab_switcher");
var _types = require("../../../types");
var _expandable_content = require("../../../components/expandable_content");
var _metadata_header = require("./metadata_header");
var _metadata_explanation = require("../../../components/metadata_explanation");
var _section_title = require("../../../components/section_title");
var _section = require("../../../components/section");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const hostExtendedMetadata = metadataInfo => {
  var _metadataInfo$cloud, _metadataInfo$host, _metadataInfo$host$os;
  return [{
    field: 'cloudProvider',
    value: metadataInfo === null || metadataInfo === void 0 ? void 0 : (_metadataInfo$cloud = metadataInfo.cloud) === null || _metadataInfo$cloud === void 0 ? void 0 : _metadataInfo$cloud.provider,
    tooltipFieldLabel: 'cloud.provider',
    tooltipLink: 'https://www.elastic.co/guide/en/ecs/current/ecs-cloud.html#field-cloud-provider'
  }, {
    field: 'operatingSystem',
    value: metadataInfo === null || metadataInfo === void 0 ? void 0 : (_metadataInfo$host = metadataInfo.host) === null || _metadataInfo$host === void 0 ? void 0 : (_metadataInfo$host$os = _metadataInfo$host.os) === null || _metadataInfo$host$os === void 0 ? void 0 : _metadataInfo$host$os.name,
    tooltipFieldLabel: 'host.os.name'
  }];
};
const hostMetadataData = metadataInfo => {
  var _metadataInfo$host2, _metadataInfo$host3, _metadataInfo$host3$o;
  return [{
    field: 'hostIp',
    value: metadataInfo === null || metadataInfo === void 0 ? void 0 : (_metadataInfo$host2 = metadataInfo.host) === null || _metadataInfo$host2 === void 0 ? void 0 : _metadataInfo$host2.ip,
    tooltipFieldLabel: 'host.ip',
    tooltipLink: 'https://www.elastic.co/guide/en/ecs/current/ecs-host.html#field-host-ip'
  }, {
    field: 'hostOsVersion',
    value: metadataInfo === null || metadataInfo === void 0 ? void 0 : (_metadataInfo$host3 = metadataInfo.host) === null || _metadataInfo$host3 === void 0 ? void 0 : (_metadataInfo$host3$o = _metadataInfo$host3.os) === null || _metadataInfo$host3$o === void 0 ? void 0 : _metadataInfo$host3$o.version,
    tooltipFieldLabel: 'host.os.version'
  }];
};
const containerExtendedMetadata = metadataInfo => {
  var _metadataInfo$contain, _metadataInfo$cloud2, _metadataInfo$cloud2$, _metadataInfo$cloud3, _metadataInfo$cloud4;
  return [{
    field: 'runtime',
    value: metadataInfo === null || metadataInfo === void 0 ? void 0 : (_metadataInfo$contain = metadataInfo.container) === null || _metadataInfo$contain === void 0 ? void 0 : _metadataInfo$contain.runtime,
    tooltipFieldLabel: 'container.runtime'
  }, {
    field: 'cloudInstanceId',
    value: metadataInfo === null || metadataInfo === void 0 ? void 0 : (_metadataInfo$cloud2 = metadataInfo.cloud) === null || _metadataInfo$cloud2 === void 0 ? void 0 : (_metadataInfo$cloud2$ = _metadataInfo$cloud2.instance) === null || _metadataInfo$cloud2$ === void 0 ? void 0 : _metadataInfo$cloud2$.id,
    tooltipFieldLabel: 'cloud.instance.id'
  }, {
    field: 'cloudImageId',
    value: metadataInfo === null || metadataInfo === void 0 ? void 0 : (_metadataInfo$cloud3 = metadataInfo.cloud) === null || _metadataInfo$cloud3 === void 0 ? void 0 : _metadataInfo$cloud3.imageId,
    tooltipFieldLabel: 'cloud.image.id'
  }, {
    field: 'cloudProvider',
    value: metadataInfo === null || metadataInfo === void 0 ? void 0 : (_metadataInfo$cloud4 = metadataInfo.cloud) === null || _metadataInfo$cloud4 === void 0 ? void 0 : _metadataInfo$cloud4.provider,
    tooltipFieldLabel: 'cloud.provider'
  }];
};
const containerMetadataData = metadataInfo => {
  var _metadataInfo$contain2, _metadataInfo$contain3, _metadataInfo$contain4, _metadataInfo$host4;
  return [{
    field: 'containerId',
    value: metadataInfo === null || metadataInfo === void 0 ? void 0 : (_metadataInfo$contain2 = metadataInfo.container) === null || _metadataInfo$contain2 === void 0 ? void 0 : _metadataInfo$contain2.id,
    tooltipFieldLabel: 'container.id'
  }, {
    field: 'containerImageName',
    value: metadataInfo === null || metadataInfo === void 0 ? void 0 : (_metadataInfo$contain3 = metadataInfo.container) === null || _metadataInfo$contain3 === void 0 ? void 0 : (_metadataInfo$contain4 = _metadataInfo$contain3.image) === null || _metadataInfo$contain4 === void 0 ? void 0 : _metadataInfo$contain4.name,
    tooltipFieldLabel: 'container.image.name'
  }, {
    field: 'hostName',
    value: metadataInfo === null || metadataInfo === void 0 ? void 0 : (_metadataInfo$host4 = metadataInfo.host) === null || _metadataInfo$host4 === void 0 ? void 0 : _metadataInfo$host4.name,
    tooltipFieldLabel: 'host.name'
  }];
};
const MetadataSummaryListWrapper = ({
  loading: metadataLoading,
  visibleMetadata,
  assetType
}) => {
  const {
    showTab
  } = (0, _use_tab_switcher.useTabSwitcherContext)();
  const onClick = () => {
    showTab(_types.ContentTabIds.METADATA);
  };
  return /*#__PURE__*/_react.default.createElement(_section.Section, {
    title: /*#__PURE__*/_react.default.createElement(_section_title.SectionTitle, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.assetDetails.overview.metadataSectionTitle",
        defaultMessage: "Metadata"
      }),
      "data-test-subj": "infraAssetDetailsMetadataTitle"
    }),
    collapsible: true,
    "data-test-subj": "infraAssetDetailsMetadataCollapsible",
    id: "metadata",
    extraAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "aria-label": _i18n.i18n.translate('xpack.infra.assetDetails.metadataSummary.showAllMetadataButton.ariaLabel', {
        defaultMessage: 'Show all metadata'
      }),
      "data-test-subj": "infraAssetDetailsMetadataShowAllButton",
      onClick: onClick,
      size: "xs",
      flush: "both",
      iconSide: "right",
      iconType: "sortRight",
      key: "metadata-link"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.assetDetails.metadataSummary.showAllMetadataButton",
      defaultMessage: "Show all"
    }))
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_metadata_explanation.MetadataExplanationMessage, {
    assetType: assetType
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, visibleMetadata.filter(metadataValue => metadataValue).map(metadataValue => {
    var _metadataValue$value;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: metadataValue.field,
      grow: false,
      css: {
        width: '200px'
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      "data-test-subj": "infraMetadataSummaryItem",
      compressed: true
    }, /*#__PURE__*/_react.default.createElement(_metadata_header.MetadataHeader, {
      metadataValue: metadataValue
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, metadataLoading && !metadataValue.value ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null) : /*#__PURE__*/_react.default.createElement(_expandable_content.ExpandableContent, {
      values: (_metadataValue$value = metadataValue.value) !== null && _metadataValue$value !== void 0 ? _metadataValue$value : _translations.NOT_AVAILABLE_LABEL
    }))));
  }))));
};
const MetadataSummaryList = ({
  metadata,
  loading,
  assetType
}) => {
  switch (assetType) {
    case 'host':
      return /*#__PURE__*/_react.default.createElement(MetadataSummaryListWrapper, {
        visibleMetadata: [...hostMetadataData(metadata === null || metadata === void 0 ? void 0 : metadata.info), ...hostExtendedMetadata(metadata === null || metadata === void 0 ? void 0 : metadata.info)],
        loading: loading,
        assetType: assetType
      });
    case 'container':
      return /*#__PURE__*/_react.default.createElement(MetadataSummaryListWrapper, {
        visibleMetadata: [...containerMetadataData(metadata === null || metadata === void 0 ? void 0 : metadata.info), ...containerExtendedMetadata(metadata === null || metadata === void 0 ? void 0 : metadata.info)],
        loading: loading,
        assetType: assetType
      });
    default:
      return /*#__PURE__*/_react.default.createElement(MetadataSummaryListWrapper, {
        visibleMetadata: [],
        loading: loading,
        assetType: assetType
      });
  }
};
exports.MetadataSummaryList = MetadataSummaryList;
const MetadataSummaryListCompact = ({
  metadata,
  loading,
  assetType
}) => {
  switch (assetType) {
    case 'host':
      return /*#__PURE__*/_react.default.createElement(MetadataSummaryListWrapper, {
        visibleMetadata: hostMetadataData(metadata === null || metadata === void 0 ? void 0 : metadata.info),
        loading: loading,
        assetType: assetType
      });
    case 'container':
      return /*#__PURE__*/_react.default.createElement(MetadataSummaryListWrapper, {
        visibleMetadata: containerMetadataData(metadata === null || metadata === void 0 ? void 0 : metadata.info),
        loading: loading,
        assetType: assetType
      });
    default:
      return /*#__PURE__*/_react.default.createElement(MetadataSummaryListWrapper, {
        visibleMetadata: [],
        loading: loading,
        assetType: assetType
      });
  }
};
exports.MetadataSummaryListCompact = MetadataSummaryListCompact;