"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isRetentionBiggerThan = exports.isBiggerThanGlobalMaxRetention = void 0;
var _i18n = require("@kbn/i18n");
var _common = require("../../../../../../common");
var _data_streams = require("../../../../lib/data_streams");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const convertToSeconds = value => {
  const {
    size,
    unit
  } = (0, _common.splitSizeAndUnits)(value);
  const sizeNum = parseInt(size, 10);
  switch (unit) {
    case 'd':
      // days to seconds
      return sizeNum * 24 * 60 * 60;
    case 'h':
      // hours to seconds
      return sizeNum * 60 * 60;
    case 'm':
      // minutes to seconds
      return sizeNum * 60;
    case 's':
      // seconds to seconds
      return sizeNum;
    case 'ms':
      // milliseconds to seconds
      return sizeNum / 1000;
    case 'micros':
      // microseconds to seconds
      return sizeNum / 1000 / 1000;
    case 'nanos':
      // nanoseconds to seconds
      return sizeNum / 1000 / 1000 / 1000;
    default:
      throw new Error(`Unknown unit: ${unit}`);
  }
};

/*
True if the first retention period is bigger than the latter one.
 */
const isRetentionBiggerThan = (valueA, valueB) => {
  const secondsA = convertToSeconds(valueA);
  const secondsB = convertToSeconds(valueB);
  return secondsA > secondsB;
};
exports.isRetentionBiggerThan = isRetentionBiggerThan;
const isBiggerThanGlobalMaxRetention = (retentionValue, retentionTimeUnit, globalMaxRetention) => {
  if (!retentionValue || !retentionTimeUnit || !globalMaxRetention) {
    return undefined;
  }
  const {
    size,
    unitText
  } = (0, _data_streams.deserializeGlobalMaxRetention)(globalMaxRetention);
  return isRetentionBiggerThan(`${retentionValue}${retentionTimeUnit}`, globalMaxRetention) ? {
    message: _i18n.i18n.translate('xpack.idxMgmt.dataStreamsDetailsPanel.editDataRetentionModal.dataRetentionFieldMaxError', {
      defaultMessage: 'Maximum data retention period on this project is {maxRetention} {unitText}.',
      // Remove the unit from the globalMaxRetention value
      values: {
        maxRetention: size,
        unitText
      }
    })
  } : undefined;
};
exports.isBiggerThanGlobalMaxRetention = isBiggerThanGlobalMaxRetention;