"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyList = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/kibana-react-plugin/public");
var _policy_list_context = require("./policy_list_context");
var _use_is_read_only = require("../../lib/use_is_read_only");
var _navigation = require("../../services/navigation");
var _components = require("./components");
var _policy_flyout = require("./policy_flyout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PolicyList = ({
  policies,
  updatePolicies
}) => {
  const history = (0, _reactRouterDom.useHistory)();
  const isReadOnly = (0, _use_is_read_only.useIsReadOnly)();
  const {
    setListAction
  } = (0, _policy_list_context.usePolicyListContext)();
  const [flyoutPolicy, setFlyoutPolicy] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    var _params$get;
    const params = new URLSearchParams(history.location.search);
    const policyParam = decodeURIComponent((_params$get = params.get('policy')) !== null && _params$get !== void 0 ? _params$get : '');
    const policyFromParam = policies.find(policy => policy.name === policyParam);
    if (policyFromParam) {
      setFlyoutPolicy(policyFromParam);
    } else {
      setFlyoutPolicy(null);
    }
  }, [history.location.search, policies, setListAction]);
  const createPolicyButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, (0, _public.reactRouterNavigate)(history, (0, _navigation.getPolicyCreatePath)()), {
    fill: true,
    iconType: "plusInCircle",
    "data-test-subj": "createPolicyButton"
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.indexLifecycleMgmt.policyTable.emptyPrompt.createButtonLabel",
    defaultMessage: "Create policy"
  }));
  if (policies.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      iconType: "managementApp",
      title: /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.policyTable.emptyPromptTitle",
        defaultMessage: "Create your first index lifecycle policy"
      })),
      body: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.policyTable.emptyPromptDescription",
        defaultMessage: " An index lifecycle policy helps you manage your indices as they age."
      }))),
      actions: createPolicyButton
    });
  }
  const rightSideItems = isReadOnly ? [] : [createPolicyButton];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_components.ListActionHandler, {
    deletePolicyCallback: () => {
      // if a flyout was open, then close it
      history.push((0, _navigation.getPoliciesListPath)());
      // update the policies in the list after 1 was deleted
      updatePolicies();
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "ilmPageHeader"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.policyTable.sectionHeading",
      defaultMessage: "Index Lifecycle Policies"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.policyTable.sectionDescription",
      defaultMessage: "Manage your indices as they age.  Attach a policy to automate when and how to transition an index through its lifecycle."
    }),
    bottomBorder: true,
    rightSideItems: rightSideItems
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_components.PolicyTable, {
    policies: policies
  }), flyoutPolicy && /*#__PURE__*/_react.default.createElement(_policy_flyout.ViewPolicyFlyout, {
    policy: flyoutPolicy
  }));
};
exports.PolicyList = PolicyList;