"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImageEmbeddablePlugin = void 0;
var _actions = require("./actions");
var _kibana_services = require("./services/kibana_services");
var _constants = require("./image_embeddable/constants");
var _create_image_action = require("./actions/create_image_action");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
// eslint-disable-next-line @typescript-eslint/no-empty-interface

// eslint-disable-next-line @typescript-eslint/no-empty-interface

class ImageEmbeddablePlugin {
  constructor() {}
  setup(core, plugins) {
    plugins.uiActions.registerTrigger(_actions.imageClickTrigger);
    plugins.embeddable.registerReactEmbeddableFactory(_constants.IMAGE_EMBEDDABLE_TYPE, async () => {
      const [_, {
        getImageEmbeddableFactory
      }, [__, {
        embeddableEnhanced
      }]] = await Promise.all([(0, _kibana_services.untilPluginStartServicesReady)(), Promise.resolve().then(() => _interopRequireWildcard(require('./image_embeddable/get_image_embeddable_factory'))), core.getStartServices()]);
      return getImageEmbeddableFactory({
        embeddableEnhanced
      });
    });
    return {};
  }
  start(core, plugins) {
    (0, _kibana_services.setKibanaServices)(core, plugins);
    (0, _kibana_services.untilPluginStartServicesReady)().then(() => {
      (0, _create_image_action.registerCreateImageAction)();
    });
    return {};
  }
  stop() {}
}
exports.ImageEmbeddablePlugin = ImageEmbeddablePlugin;