"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ensureDeleteUnenrolledAgentsSetting = ensureDeleteUnenrolledAgentsSetting;
exports.getPreconfiguredDeleteUnenrolledAgentsSettingFromConfig = getPreconfiguredDeleteUnenrolledAgentsSettingFromConfig;
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getPreconfiguredDeleteUnenrolledAgentsSettingFromConfig(config) {
  return config.enableDeleteUnenrolledAgents;
}
async function ensureDeleteUnenrolledAgentsSetting(soClient, enableDeleteUnenrolledAgents) {
  if (enableDeleteUnenrolledAgents === undefined) {
    var _settings$delete_unen;
    const settings = await _.settingsService.getSettingsOrUndefined(soClient);
    if (!(settings !== null && settings !== void 0 && (_settings$delete_unen = settings.delete_unenrolled_agents) !== null && _settings$delete_unen !== void 0 && _settings$delete_unen.is_preconfigured)) {
      return;
    }
  }
  await _.settingsService.saveSettings(soClient, {
    delete_unenrolled_agents: {
      enabled: !!enableDeleteUnenrolledAgents,
      is_preconfigured: enableDeleteUnenrolledAgents !== undefined
    }
  }, {
    fromSetup: true
  });
}