"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteIlms = void 0;
var _pMap = _interopRequireDefault(require("p-map"));
var _app_context = require("../../../app_context");
var _constants = require("../../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteIlms = async (esClient, ilmPolicyIds) => {
  const logger = _app_context.appContextService.getLogger();
  await (0, _pMap.default)(ilmPolicyIds, async ilmPolicyId => {
    await esClient.transport.request({
      method: 'DELETE',
      path: `_ilm/policy/${ilmPolicyId}`
    }, {
      ignore: [404, 400]
    });
    logger.debug(`Deleted ilm policy with id: ${ilmPolicyId}`);
  }, {
    concurrency: _constants.MAX_CONCURRENT_ILM_POLICIES_OPERATIONS
  });
};
exports.deleteIlms = deleteIlms;