"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = void 0;
var _constants = require("../../../common/constants");
var _api_privileges = require("../../constants/api_privileges");
var _constants2 = require("../../constants");
var _types = require("../../types");
var _errors = require("../schema/errors");
var _handler = require("./handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerRoutes = router => {
  // get fleet server health check by host id
  router.versioned.post({
    path: _constants2.APP_API_ROUTES.HEALTH_CHECK_PATTERN,
    security: {
      authz: {
        requiredPrivileges: [_api_privileges.FLEET_API_PRIVILEGES.SETTINGS.ALL]
      }
    },
    summary: `Check Fleet Server health`,
    options: {
      tags: ['oas-tag:Fleet internals']
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.PostHealthCheckRequestSchema,
      response: {
        200: {
          body: () => _types.PostHealthCheckResponseSchema
        },
        400: {
          body: _errors.genericErrorResponse
        },
        404: {
          body: _errors.genericErrorResponse
        }
      }
    }
  }, _handler.postHealthCheckHandler);
};
exports.registerRoutes = registerRoutes;