"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIntraAppState = useIntraAppState;
var _reactRouterDom = require("react-router-dom");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Retrieve UI Route state from the React Router History for the current URL location.
 * This state can be used by other Kibana Apps to influence certain behaviours in Ingest, for example,
 * redirecting back to an given Application after a craete action.
 */
function useIntraAppState() {
  const location = (0, _reactRouterDom.useLocation)();
  return location.state;
}