"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PlatformSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _epm = require("../../common/constants/epm");
var _hooks = require("../hooks");
var _kubernetes_instructions = require("./agent_enrollment_flyout/kubernetes_instructions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PlatformSelector = ({
  installCommand,
  hasK8sIntegration,
  cloudSecurityIntegration,
  hasK8sIntegrationMultiPage,
  isManaged,
  enrollToken,
  hasFleetServer,
  fleetServerHost,
  fullCopyButton,
  onCopy
}) => {
  const {
    platform,
    setPlatform
  } = (0, _hooks.usePlatform)();
  const [showExtendedPlatforms, setShowExtendedPlatforms] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (hasK8sIntegration || (cloudSecurityIntegration === null || cloudSecurityIntegration === void 0 ? void 0 : cloudSecurityIntegration.integrationType) === _epm.FLEET_CLOUD_SECURITY_POSTURE_KSPM_POLICY_TEMPLATE && isManaged) {
      setPlatform('kubernetes');
    }
  }, [hasK8sIntegration, cloudSecurityIntegration, isManaged, setPlatform]);

  // Show K8 as a platform option if policy has K8s integration or is managed
  const showK8 = !hasFleetServer && (isManaged || hasK8sIntegration);
  const extendedPlatformOptions = [...(showK8 ? [_hooks.KUBERNETES_PLATFORM_OPTION] : []), ..._hooks.EXTENDED_PLATFORM_OPTIONS];
  const extendedPlatforms = extendedPlatformOptions.map(option => option.id);
  const [copyButtonClicked, setCopyButtonClicked] = (0, _react.useState)(false);
  const systemPackageCallout = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.fleet.enrollmentInstructions.callout', {
      defaultMessage: 'We recommend using the installers (TAR/ZIP) over system packages (RPM/DEB) because they provide the ability to upgrade your agent with Fleet.'
    }),
    color: "warning",
    iconType: "warning"
  });
  const k8sCallout = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.fleet.enrollmentInstructions.k8sCallout', {
      defaultMessage: 'We recommend adding the Kubernetes integration to your agent policy in order to get useful metrics and logs from your Kubernetes clusters.'
    }),
    color: "warning",
    iconType: "warning"
  });
  const k8sCSPMCallout = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.fleet.enrollmentInstructions.placeHolderCallout', {
      defaultMessage: 'We strongly advise against deploying CSPM within a Kubernetes cluster. Doing so may lead to redundant data fetching, which can cause increased consumption costs within your Elastic account and potentially trigger API rate limiting in your cloud account(s).'
    }),
    color: "warning",
    iconType: "warning"
  });
  const macCallout = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.fleet.enrollmentInstructions.macCallout', {
      defaultMessage: 'We recommend against deploying this integration within Mac as it is currently not being supported.'
    }),
    color: "warning",
    iconType: "warning"
  });
  const onTextAreaClick = () => {
    if (onCopy) onCopy();
  };
  const onCopyButtonClick = copy => {
    copy();
    setCopyButtonClicked(true);
    if (onCopy) onCopy();
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !hasK8sIntegrationMultiPage && /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    "aria-label": _i18n.i18n.translate('xpack.fleet.agentEnrollment.visiblePlatformSelectorLabel', {
      defaultMessage: 'Platform options'
    })
  }, _hooks.VISIBLE_PLATFORM_OPTIONS.map(option => /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    key: option.id,
    isToggle: true,
    isSelected: platform === option.id,
    hasActiveFilters: platform === option.id,
    onClick: () => setPlatform(option.id),
    "data-test-subj": option['data-test-subj']
  }, option.label)), /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      iconType: "arrowDown",
      "data-test-subj": "platformSelectorExtended",
      onClick: () => setShowExtendedPlatforms(!showExtendedPlatforms),
      isSelected: showExtendedPlatforms,
      hasActiveFilters: extendedPlatforms.includes(platform),
      numActiveFilters: extendedPlatforms.includes(platform) ? 1 : 0,
      css: (0, _react2.css)`
                    .euiFilterButton__text {
                      min-inline-size: 0;
                    }
                  `
    }, "\u2026"),
    isOpen: showExtendedPlatforms,
    closePopover: () => setShowExtendedPlatforms(false),
    panelPaddingSize: "none",
    repositionOnScroll: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "aria-label": _i18n.i18n.translate('xpack.fleet.agentEnrollment.extendedPlatformSelectorLabel', {
      defaultMessage: 'Additional platform options'
    }),
    singleSelection: true,
    options: extendedPlatformOptions.map(option => ({
      key: option.id,
      label: option.label,
      checked: platform === option.id ? 'on' : undefined,
      'data-test-subj': option['data-test-subj']
    })),
    onChange: (_allOptions, _event, option) => setPlatform(option.key),
    css: {
      width: 150
    },
    listProps: {
      paddingSize: 'none',
      onFocusBadge: false
    }
  }, list => list))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), ['deb_aarch64', 'deb_x86_64', 'rpm_aarch64', 'rpm_x86_64'].includes(platform) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, systemPackageCallout, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), ['mac_aarch64', 'mac_x86_64'].includes(platform) && ((cloudSecurityIntegration === null || cloudSecurityIntegration === void 0 ? void 0 : cloudSecurityIntegration.integrationType) === _epm.FLEET_CLOUD_SECURITY_POSTURE_CSPM_POLICY_TEMPLATE || (cloudSecurityIntegration === null || cloudSecurityIntegration === void 0 ? void 0 : cloudSecurityIntegration.integrationType) === _epm.FLEET_CLOUD_SECURITY_POSTURE_KSPM_POLICY_TEMPLATE) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, macCallout, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), platform === 'kubernetes' && (cloudSecurityIntegration === null || cloudSecurityIntegration === void 0 ? void 0 : cloudSecurityIntegration.integrationType) === _epm.FLEET_CLOUD_SECURITY_POSTURE_CSPM_POLICY_TEMPLATE && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, k8sCSPMCallout, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), platform === 'kubernetes' && !hasK8sIntegration && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, k8sCallout, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), platform === 'kubernetes' && isManaged && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_kubernetes_instructions.KubernetesInstructions, {
    onCopy: onCopy,
    onDownload: onCopy,
    enrollmentAPIKey: enrollToken,
    fleetServerHost: fleetServerHost
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), !hasK8sIntegrationMultiPage && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, platform === 'kubernetes' && /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollment.kubernetesCommandInstructions",
    defaultMessage: "From the directory where the manifest is downloaded, run the apply command."
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    onClick: onTextAreaClick,
    fontSize: "m",
    isCopyable: !fullCopyButton,
    paddingSize: "m",
    css: (0, _react2.css)`
                max-width: 1100px;
              `,
    whiteSpace: "pre"
  }, installCommand[platform]), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), fullCopyButton && /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: installCommand[platform]
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    iconType: "copyClipboard",
    size: "m",
    onClick: () => onCopyButtonClick(copy)
  }, copyButtonClicked ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.enrollmentInstructions.copyButtonClicked",
    defaultMessage: "Copied"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.enrollmentInstructions.copyButton",
    defaultMessage: "Copy to clipboard"
  }))))));
};
exports.PlatformSelector = PlatformSelector;