"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNodeLabel = void 0;
var _formatters = require("../formatters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getNodeLabel = (nodeName, column, formatters, defaultFormatFactory) => {
  const formatter = (0, _formatters.getAvailableFormatter)(column, formatters, defaultFormatFactory);
  if (formatter) {
    var _formatter$convert;
    return (_formatter$convert = formatter.convert(nodeName)) !== null && _formatter$convert !== void 0 ? _formatter$convert : '';
  }
  return String(nodeName);
};
exports.getNodeLabel = getNodeLabel;