"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLensFormulaHelper = void 0;
var _react = require("react");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLensFormulaHelper = () => {
  const {
    services: {
      lens
    }
  } = (0, _public.useKibana)();
  const {
    data: lensHelper
  } = (0, _public2.useFetcher)(async () => {
    return lens.stateHelperApi();
  }, [lens]);
  return (0, _react.useMemo)(() => {
    if (lensHelper) {
      return lensHelper.formula;
    }
  }, [lensHelper]);
};
exports.useLensFormulaHelper = useLensFormulaHelper;