"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.suggest = suggest;
var _helper = require("../../helper");
var _helpers = require("../../../shared/helpers");
var _complete_items = require("../../complete_items");
var _metadata = require("../metadata");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function suggest({
  innerText,
  command,
  callbacks,
  getSources,
  getSourcesFromQuery
}) {
  if ((0, _helpers.withinQuotes)(innerText)) {
    return [];
  }
  const suggestions = [];
  const indexes = getSourcesFromQuery('index');
  // Function to add suggestions based on canRemoveQuote
  const addSuggestionsBasedOnQuote = definitions => {
    suggestions.push(...definitions);
  };
  const metadataSuggestions = (0, _metadata.getMetadataSuggestions)(command, innerText);
  if (metadataSuggestions) {
    return metadataSuggestions;
  }
  const metadataOverlap = (0, _helper.getOverlapRange)(innerText, 'METADATA');

  // TS /
  if (indexes.length === 0) {
    var _callbacks$getTimeser;
    const timeseriesIndices = await (callbacks === null || callbacks === void 0 ? void 0 : (_callbacks$getTimeser = callbacks.getTimeseriesIndices) === null || _callbacks$getTimeser === void 0 ? void 0 : _callbacks$getTimeser.call(callbacks));
    if (!timeseriesIndices) {
      return [];
    }
    return (0, _helper.specialIndicesToSuggestions)(timeseriesIndices.indices);
  }
  // TS something /
  else if (indexes.length > 0 && /\s$/.test(innerText) && !(0, _helpers.isRestartingExpression)(innerText)) {
    suggestions.push(_metadata.metadataSuggestion);
    suggestions.push(_complete_items.commaCompleteItem);
    suggestions.push(_complete_items.pipeCompleteItem);
  }
  // TS something MET/
  else if (indexes.length > 0 && /^TS\s+\S+\s+/i.test(innerText) && metadataOverlap) {
    suggestions.push(_metadata.metadataSuggestion);
  }
  // TS someth/
  // TS something/
  // TS something, /
  else if (indexes.length) {
    const sources = await getSources();
    const additionalSuggestions = await (0, _helper.additionalSourcesSuggestions)(innerText, sources, indexes.map(({
      name
    }) => name), []);
    addSuggestionsBasedOnQuote(additionalSuggestions);
  }
  return suggestions;
}