"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ingestKeysToRuby = exports.ingestKeysToPHP = exports.ingestKeysToJSON = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ingestKeysToJSON = extraIngestDocumentValues => extraIngestDocumentValues ? Object.entries(extraIngestDocumentValues).reduce((result, value) => {
  result += `, "${value[0]}": ${value[1]}`;
  return result;
}, '') : '';
exports.ingestKeysToJSON = ingestKeysToJSON;
const ingestKeysToPHP = extraIngestDocumentValues => extraIngestDocumentValues ? Object.entries(extraIngestDocumentValues).reduce((result, value) => {
  result += `\n    '${value[0]}' => ${value[1]},`;
  return result;
}, '') : '';
exports.ingestKeysToPHP = ingestKeysToPHP;
const ingestKeysToRuby = extraIngestDocumentValues => extraIngestDocumentValues ? Object.entries(extraIngestDocumentValues).reduce((result, value) => {
  result += `, ${value[0]}: ${value[1]}`;
  return result;
}, '') : '';
exports.ingestKeysToRuby = ingestKeysToRuby;