"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SettingsCheckableCard = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SettingsCheckableCard = ({
  checked,
  description,
  disabled,
  id,
  label,
  onChange
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
  label: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, label)),
  disabled: disabled,
  checkableType: "checkbox",
  onChange: onChange,
  checked: checked,
  id: id
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: "subdued",
  size: "s"
}, /*#__PURE__*/_react.default.createElement("p", null, description)));
exports.SettingsCheckableCard = SettingsCheckableCard;