"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorTotalStats = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../shared/kibana");
var _indices = require("../../utils/indices");
var _language_to_text = require("../../utils/language_to_text");
var _connector_overview_panels = require("./connector/connector_overview_panels");
var _name_and_description_stats = require("./name_and_description_stats");
var _overview = require("./overview.logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorTotalStats = () => {
  var _ref, _NATIVE_CONNECTORS$fi, _NATIVE_CONNECTORS$fi2, _indexData$connector$;
  const {
    indexData,
    isError,
    isLoading
  } = (0, _kea.useValues)(_overview.OverviewLogic);
  const {
    connectorTypes
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const hideStats = isLoading || isError;
  const NATIVE_CONNECTORS = (0, _react.useMemo)(() => connectorTypes.filter(({
    isNative
  }) => isNative), [connectorTypes]);
  if (!(0, _indices.isConnectorIndex)(indexData)) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  const stats = [{
    // @ts-expect-error upgrade typescript v4.9.5
    'data-test-subj': 'entSearchContent-indexOverview-totalStats-ingestionType',
    description: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.totalStats.ingestionTypeCardLabel', {
      defaultMessage: 'Ingestion type'
    }),
    isLoading: hideStats,
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.totalStats.connectorIngestionMethodLabel', {
      defaultMessage: 'Connector'
    })
  }, {
    // @ts-expect-error upgrade typescript v4.9.5
    'data-test-subj': 'entSearchContent-indexOverview-totalStats-connectorType',
    description: _i18n.i18n.translate('xpack.enterpriseSearch.connector.connectorTypePanel.title', {
      defaultMessage: 'Connector type'
    }),
    title: (_ref = (_NATIVE_CONNECTORS$fi = (_NATIVE_CONNECTORS$fi2 = NATIVE_CONNECTORS.find(connector => connector.serviceType === indexData.connector.service_type)) === null || _NATIVE_CONNECTORS$fi2 === void 0 ? void 0 : _NATIVE_CONNECTORS$fi2.name) !== null && _NATIVE_CONNECTORS$fi !== void 0 ? _NATIVE_CONNECTORS$fi : indexData.connector.service_type) !== null && _ref !== void 0 ? _ref : _i18n.i18n.translate('xpack.enterpriseSearch.connector.connectorTypePanel.unknown.label', {
      defaultMessage: 'Unknown'
    })
  }, {
    description: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.totalStats.languageLabel', {
      defaultMessage: 'Language analyzer'
    }),
    isLoading: hideStats,
    title: (0, _language_to_text.languageToText)((_indexData$connector$ = indexData.connector.language) !== null && _indexData$connector$ !== void 0 ? _indexData$connector$ : '')
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_name_and_description_stats.NameAndDescriptionStats, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row"
  }, stats.map((item, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: index
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "primary",
    hasShadow: false,
    paddingSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, (0, _extends2.default)({
    titleSize: "s"
  }, item)))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_connector_overview_panels.ConnectorOverviewPanels, null));
};
exports.ConnectorTotalStats = ConnectorTotalStats;