"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchApplicationIndicesFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _health_colors = require("../../../shared/constants/health_colors");
var _search_application_view_index_link = require("../search_application/search_application_view_index_link");
var _search_application_indices_flyout_logic = require("./search_application_indices_flyout_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchApplicationIndicesFlyout = () => {
  const {
    searchApplicationData,
    searchApplicationName,
    isSearchApplicationLoading,
    isFlyoutVisible
  } = (0, _kea.useValues)(_search_application_indices_flyout_logic.SearchApplicationIndicesFlyoutLogic);
  const {
    closeFlyout
  } = (0, _kea.useActions)(_search_application_indices_flyout_logic.SearchApplicationIndicesFlyoutLogic);
  if (!searchApplicationData) return null;
  const {
    indices
  } = searchApplicationData;
  const columns = [{
    field: 'name',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.list.indicesFlyout.table.name.columnTitle', {
      defaultMessage: 'Index name'
    }),
    render: indexName => /*#__PURE__*/_react.default.createElement(_search_application_view_index_link.SearchApplicationViewIndexLink, {
      indexName: indexName,
      dataTestSubj: "search-application-index-link",
      dataTelemetryId: "entSearchApplications-list-viewIndex"
    }),
    sortable: true,
    truncateText: true,
    width: '40%'
  }, {
    field: 'health',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.list.indicesFlyout.table.health.columnTitle', {
      defaultMessage: 'Index health'
    }),
    render: health => {
      var _healthColorsMap$heal;
      return /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "dot",
        color: (_healthColorsMap$heal = _health_colors.healthColorsMap[health]) !== null && _healthColorsMap$heal !== void 0 ? _healthColorsMap$heal : ''
      }), "\xA0", health !== null && health !== void 0 ? health : '-');
    },
    sortable: true,
    truncateText: true,
    width: '15%'
  }, {
    field: 'count',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.list.indicesFlyout.table.docsCount.columnTitle', {
      defaultMessage: 'Docs count'
    }),
    sortable: true,
    truncateText: true,
    width: '15%'
  }];
  if (isFlyoutVisible) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
      ownFocus: true,
      "aria-labelledby": "searchApplicationIndicesFlyout",
      onClose: closeFlyout
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
      hasBorder: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "m"
    }, /*#__PURE__*/_react.default.createElement("h2", {
      id: "searchApplicationIndicesFlyout"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.list.indicesFlyout.title', {
      defaultMessage: 'View Indices'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.searchApplications.list.indicesFlyout.subTitle",
      defaultMessage: "View the indices associated with {searchApplicationName}",
      values: {
        searchApplicationName
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
      items: indices,
      columns: columns,
      loading: isSearchApplicationLoading
    })));
  } else {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
};
exports.SearchApplicationIndicesFlyout = SearchApplicationIndicesFlyout;