"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultAssistantGraph = exports.DEFAULT_ASSISTANT_GRAPH_ID = void 0;
var _langgraph = require("@langchain/langgraph");
var _prebuilt = require("@langchain/langgraph/prebuilt");
var _step_router = require("./nodes/step_router");
var _run_agent = require("./nodes/run_agent");
var _constants = require("./constants");
var _state = require("./state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_ASSISTANT_GRAPH_ID = exports.DEFAULT_ASSISTANT_GRAPH_ID = 'Default Security Assistant Graph';
const getDefaultAssistantGraph = async ({
  actionsClient,
  contentReferencesStore,
  createLlmInstance,
  logger,
  savedObjectsClient,
  // some chat models (bedrock) require a signal to be passed on agent invoke rather than the signal passed to the chat model
  signal,
  tools
}) => {
  try {
    // Default node parameters
    const nodeParams = {
      actionsClient,
      logger,
      savedObjectsClient,
      contentReferencesStore
    };
    const stateAnnotation = _state.AssistantStateAnnotation;
    const llm = await createLlmInstance();
    if (!llm.bindTools) {
      throw new Error('Llm instance does not support bindTools method');
    }
    const llmWithTools = llm.bindTools(tools);
    const toolNode = new _prebuilt.ToolNode(tools);

    // Put together a new graph using default state from above
    const graph = new _langgraph.StateGraph(stateAnnotation).addNode(_constants.NodeType.AGENT, state => (0, _run_agent.runAgent)({
      ...nodeParams,
      config: {
        signal
      },
      state,
      model: llmWithTools
    })).addNode(_constants.NodeType.TOOLS, toolNode).addEdge(_langgraph.START, _constants.NodeType.AGENT).addEdge(_constants.NodeType.TOOLS, _constants.NodeType.AGENT).addConditionalEdges(_constants.NodeType.AGENT, _step_router.stepRouter, {
      [_constants.NodeType.TOOLS]: _constants.NodeType.TOOLS,
      [_constants.NodeType.END]: _langgraph.END
    });
    return graph.compile();
  } catch (e) {
    throw new Error(`Unable to compile DefaultAssistantGraph\n${e}`);
  }
};
exports.getDefaultAssistantGraph = getDefaultAssistantGraph;