"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRunAttackDiscoveriesWithReplacements = void 0;
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _get_discoveries_with_original_values = require("../../get_discoveries_with_original_values");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRunAttackDiscoveriesWithReplacements = run => {
  var _run$outputs$insights, _run$outputs, _run$outputs2, _run$outputs$replacem, _run$outputs3;
  // fallback to the legacy `attackDiscoveries` property for backwards compatibility
  const runAttackDiscoveries = (_run$outputs$insights = (_run$outputs = run.outputs) === null || _run$outputs === void 0 ? void 0 : _run$outputs.insights) !== null && _run$outputs$insights !== void 0 ? _run$outputs$insights : (_run$outputs2 = run.outputs) === null || _run$outputs2 === void 0 ? void 0 : _run$outputs2.attackDiscoveries;
  const runReplacements = (_run$outputs$replacem = (_run$outputs3 = run.outputs) === null || _run$outputs3 === void 0 ? void 0 : _run$outputs3.replacements) !== null && _run$outputs$replacem !== void 0 ? _run$outputs$replacem : {};

  // NOTE: calls to `parse` throw an error if the Run Input is invalid
  const validatedAttackDiscoveries = _elasticAssistantCommon.AttackDiscoveries.parse(runAttackDiscoveries);
  const validatedReplacements = _elasticAssistantCommon.Replacements.parse(runReplacements);
  const withReplacements = (0, _get_discoveries_with_original_values.getDiscoveriesWithOriginalValues)({
    attackDiscoveries: validatedAttackDiscoveries,
    replacements: validatedReplacements
  });
  return withReplacements;
};
exports.getRunAttackDiscoveriesWithReplacements = getRunAttackDiscoveriesWithReplacements;