"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.patchRequest = void 0;
var _request = _interopRequireDefault(require("@hapi/hapi/lib/request.js"));
var _http = require("http");
var _util = require("util");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// @ts-expect-error not in the definition file

const patchRequest = () => {
  // HAPI request
  _request.default.prototype.toString = function () {
    return `[HAPI.Request method="${this.method}" url="${this.url}"]`;
  };
  _request.default.prototype.toJSON = function () {
    return {
      method: this.method,
      url: String(this.url)
    };
  };
  _request.default.prototype[_util.inspect.custom] = function () {
    return this.toJSON();
  };

  // http.IncomingMessage
  const IncomingMessageProto = _http.IncomingMessage.prototype;
  IncomingMessageProto.toString = function () {
    return `[http.IncomingMessage method="${this.method}" url="${this.url}" complete="${this.complete}" aborted="${this.aborted}"]`;
  };

  // @ts-expect-error missing definition
  IncomingMessageProto.toJSON = function () {
    return {
      method: this.method,
      url: this.url,
      complete: this.complete,
      aborted: this.aborted
    };
  };

  // @ts-expect-error missing definition
  IncomingMessageProto[_util.inspect.custom] = function () {
    // @ts-expect-error missing definition
    return this.toJSON();
  };
};
exports.patchRequest = patchRequest;