"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openDataControlEditor = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactFastCompare = _interopRequireDefault(require("react-fast-compare"));
var _i18n = require("@kbn/i18n");
var _presentationContainers = require("@kbn/presentation-containers");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _kibana_services = require("../../services/kibana_services");
var _data_control_editor = require("./data_control_editor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const openDataControlEditor = ({
  initialState,
  controlType,
  controlId,
  initialDefaultPanelTitle,
  onSave,
  controlGroupApi
}) => {
  const closeOverlay = overlayRef => {
    if ((0, _presentationPublishing.apiHasParentApi)(controlGroupApi) && (0, _presentationContainers.tracksOverlays)(controlGroupApi.parentApi)) {
      controlGroupApi.parentApi.clearOverlays();
    }
    overlayRef.close();
  };
  const onCancel = (newState, overlay) => {
    if ((0, _reactFastCompare.default)(initialState, newState)) {
      closeOverlay(overlay);
      return;
    }
    _kibana_services.coreServices.overlays.openConfirm(_i18n.i18n.translate('controls.controlGroup.management.discard.sub', {
      defaultMessage: `Changes that you've made to this control will be discarded, are you sure you want to continue?`
    }), {
      confirmButtonText: _i18n.i18n.translate('controls.controlGroup.management.discard.confirm', {
        defaultMessage: 'Discard changes'
      }),
      cancelButtonText: _i18n.i18n.translate('controls.controlGroup.management.discard.cancel', {
        defaultMessage: 'Cancel'
      }),
      title: _i18n.i18n.translate('controls.controlGroup.management.discard.title', {
        defaultMessage: 'Discard changes?'
      }),
      buttonColor: 'danger'
    }).then(confirmed => {
      if (confirmed) {
        closeOverlay(overlay);
      }
    });
  };
  const overlay = _kibana_services.coreServices.overlays.openFlyout((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_data_control_editor.DataControlEditor, {
    controlGroupApi: controlGroupApi,
    initialState: initialState,
    controlType: controlType,
    controlId: controlId,
    initialDefaultPanelTitle: initialDefaultPanelTitle,
    onCancel: state => {
      onCancel(state, overlay);
    },
    onSave: (state, selectedControlType) => {
      closeOverlay(overlay);
      onSave({
        type: selectedControlType,
        state
      });
    }
  }), _kibana_services.coreServices), {
    size: 'm',
    maxWidth: 500,
    paddingSize: 'm',
    onClose: () => closeOverlay(overlay)
  });
  if ((0, _presentationPublishing.apiHasParentApi)(controlGroupApi) && (0, _presentationContainers.tracksOverlays)(controlGroupApi.parentApi)) {
    controlGroupApi.parentApi.openOverlay(overlay);
  }
};
exports.openDataControlEditor = openDataControlEditor;