"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SidebarContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _workpad = require("../../../state/selectors/workpad");
var _sidebar_content = require("./sidebar_content.component");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SidebarContent = ({
  commit
}) => {
  const selectedToplevelNodes = (0, _reactRedux.useSelector)(state => (0, _workpad.getSelectedToplevelNodes)(state), _reactRedux.shallowEqual);
  const selectedElementId = (0, _reactRedux.useSelector)(state => (0, _workpad.getSelectedElementId)(state), _reactRedux.shallowEqual);
  return /*#__PURE__*/_react.default.createElement(_sidebar_content.SidebarContent, {
    commit: commit,
    selectedToplevelNodes: selectedToplevelNodes,
    selectedElementId: selectedElementId
  });
};
exports.SidebarContent = SidebarContent;