"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleAnalyzeHeaders = handleAnalyzeHeaders;
var _output_parsers = require("@langchain/core/output_parsers");
var _prompts = require("./prompts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function handleAnalyzeHeaders({
  state,
  model
}) {
  const outputParser = new _output_parsers.StringOutputParser();
  const celProgramGraph = _prompts.CEL_ANALYZE_HEADERS_PROMPT.pipe(model).pipe(outputParser);
  const hasProgramHeadersResult = await celProgramGraph.invoke({
    cel_program: state.currentProgram
  });
  return {
    hasProgramHeaders: JSON.parse(hasProgramHeadersResult),
    lastExecutedChain: 'analyzeProgramHeaders'
  };
}