"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReviewStep = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _codeEditor = require("@kbn/code-editor");
var _monaco = require("@kbn/monaco");
var _react2 = _interopRequireWildcard(require("react"));
var _fields_table = require("./fields_table");
var _step_content_wrapper = require("../step_content_wrapper");
var _use_check_pipeline = require("./use_check_pipeline");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const flyoutBodyCss = (0, _react.css)`
  height: 100%;
  .euiFlyoutBody__overflowContent {
    height: 100%;
    padding: 0;
  }
`;
const ReviewStep = exports.ReviewStep = /*#__PURE__*/_react2.default.memo(({
  integrationSettings,
  isGenerating,
  result
}) => {
  const [customPipeline, setCustomPipeline] = (0, _react2.useState)();
  const {
    error: checkPipelineError
  } = (0, _use_check_pipeline.useCheckPipeline)({
    customPipeline,
    integrationSettings
  });
  const [isPipelineEditionVisible, setIsPipelineEditionVisible] = (0, _react2.useState)(false);
  const [updatedPipeline, setUpdatedPipeline] = (0, _react2.useState)();
  const changeCustomPipeline = (0, _react2.useCallback)(value => {
    setUpdatedPipeline(value);
  }, []);
  const saveCustomPipeline = (0, _react2.useCallback)(() => {
    if (updatedPipeline) {
      try {
        const pipeline = JSON.parse(updatedPipeline);
        setCustomPipeline(pipeline);
      } catch (_) {
        return; // Syntax errors are already displayed in the code editor
      }
    }
    setIsPipelineEditionVisible(false);
  }, [updatedPipeline]);
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react2.default.createElement(_step_content_wrapper.StepContentWrapper, {
    title: i18n.TITLE,
    subtitle: i18n.DESCRIPTION,
    right: /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
      onClick: () => setIsPipelineEditionVisible(true),
      "data-test-subj": "editPipelineButton"
    }, i18n.EDIT_PIPELINE_BUTTON)
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    "data-test-subj": "reviewStep"
  }, isGenerating ? /*#__PURE__*/_react2.default.createElement(_eui.EuiLoadingSpinner, {
    size: "l"
  }) : /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, checkPipelineError && /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    color: "danger",
    size: "s"
  }, checkPipelineError), /*#__PURE__*/_react2.default.createElement(_fields_table.FieldsTable, {
    documents: result === null || result === void 0 ? void 0 : result.docs
  })), isPipelineEditionVisible && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlyout, {
    onClose: () => setIsPipelineEditionVisible(false),
    "aria-labelledby": flyoutTitleId
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react2.default.createElement("h2", {
    id: flyoutTitleId
  }, i18n.INGEST_PIPELINE_TITLE))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlyoutBody, {
    css: flyoutBodyCss
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    wrap: false,
    responsive: false,
    css: {
      height: '100%'
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react2.default.createElement(_codeEditor.CodeEditor, {
    languageId: _monaco.XJsonLang.ID,
    value: JSON.stringify(result === null || result === void 0 ? void 0 : result.pipeline, null, 2),
    onChange: changeCustomPipeline,
    width: "100%",
    height: "100%",
    options: {
      fontSize: 12,
      minimap: {
        enabled: true
      },
      folding: true,
      scrollBeyondLastLine: false,
      wordWrap: 'on',
      wrappingIndent: 'indent',
      automaticLayout: true
    }
  })))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "none",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: saveCustomPipeline,
    "data-test-subj": "savePipelineButton"
  }, i18n.SAVE_BUTTON)))))));
});
ReviewStep.displayName = 'ReviewStep';