"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TraceWaterfallEmbeddable = TraceWaterfallEmbeddable;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _use_fetcher = require("../../hooks/use_fetcher");
var _loading = require("./loading");
var _trace_waterfall = require("../../components/shared/trace_waterfall");
var _use_trace_waterfall = require("../../components/shared/trace_waterfall/use_trace_waterfall");
var _waterfall_helpers = require("../../components/app/transaction_details/waterfall_with_summary/waterfall_container/waterfall/waterfall_helpers/waterfall_helpers");
var _waterfall_legends = require("../../components/app/transaction_details/waterfall_with_summary/waterfall_container/waterfall_legends");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TraceWaterfallEmbeddable({
  serviceName,
  entryTransactionId,
  rangeFrom,
  rangeTo,
  traceId,
  displayLimit,
  scrollElement,
  onNodeClick,
  getRelatedErrorsHref
}) {
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/unified_traces/{traceId}', {
      params: {
        path: {
          traceId
        },
        query: {
          entryTransactionId,
          start: rangeFrom,
          end: rangeTo
        }
      }
    });
  }, [entryTransactionId, rangeFrom, rangeTo, traceId]);
  const legends = (0, _use_trace_waterfall.getServiceLegends)((data === null || data === void 0 ? void 0 : data.traceItems) || []);
  if ((0, _use_fetcher.isPending)(status)) {
    return /*#__PURE__*/_react.default.createElement(_loading.Loading, null);
  }
  if (data === undefined) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      "data-test-subj": "TraceWaterfallEmbeddableNoData",
      color: "danger",
      size: "s",
      title: _i18n.i18n.translate('xpack.apm.traceWaterfallEmbeddable.noDataCalloutLabel', {
        defaultMessage: 'Trace waterfall could not be loaded.'
      })
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_waterfall_legends.WaterfallLegends, {
    serviceName: serviceName,
    legends: legends,
    type: _waterfall_helpers.WaterfallLegendType.ServiceName
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_trace_waterfall.TraceWaterfall, {
    traceItems: data === null || data === void 0 ? void 0 : data.traceItems,
    onClick: onNodeClick,
    scrollElement: scrollElement,
    getRelatedErrorsHref: getRelatedErrorsHref,
    isEmbeddable: true
  })));
}