"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.maintenanceWindowResponseSchema = exports.maintenanceWindowEventSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _v = require("../constants/v1");
var _shared = require("../../../shared");
var _r_rule = require("../../../../r_rule");
var _alerts_filter_query = require("../../../../alerts_filter_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const maintenanceWindowEventSchema = exports.maintenanceWindowEventSchema = _configSchema.schema.object({
  gte: _configSchema.schema.string(),
  lte: _configSchema.schema.string()
});
const maintenanceWindowResponseSchema = exports.maintenanceWindowResponseSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  title: _configSchema.schema.string(),
  enabled: _configSchema.schema.boolean(),
  duration: _configSchema.schema.number(),
  expiration_date: _configSchema.schema.string(),
  events: _configSchema.schema.arrayOf(maintenanceWindowEventSchema),
  r_rule: _r_rule.rRuleResponseSchemaV1,
  created_by: _configSchema.schema.nullable(_configSchema.schema.string()),
  updated_by: _configSchema.schema.nullable(_configSchema.schema.string()),
  created_at: _configSchema.schema.string(),
  updated_at: _configSchema.schema.string(),
  event_start_time: _configSchema.schema.nullable(_configSchema.schema.string()),
  event_end_time: _configSchema.schema.nullable(_configSchema.schema.string()),
  status: _configSchema.schema.oneOf([_configSchema.schema.literal(_v.maintenanceWindowStatus.RUNNING), _configSchema.schema.literal(_v.maintenanceWindowStatus.UPCOMING), _configSchema.schema.literal(_v.maintenanceWindowStatus.FINISHED), _configSchema.schema.literal(_v.maintenanceWindowStatus.ARCHIVED)]),
  category_ids: _shared.maintenanceWindowCategoryIdsSchemaV1,
  scoped_query: _configSchema.schema.maybe(_configSchema.schema.nullable(_alerts_filter_query.alertsFilterQuerySchemaV1))
});