"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiAccordionArrow = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _button = require("../../button");
var _accordion_arrow = require("./accordion_arrow.styles");
var _react2 = require("@emotion/react");
var _excluded = ["arrowDisplay", "arrowProps", "isOpen"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiAccordionArrow = exports.EuiAccordionArrow = function EuiAccordionArrow(_ref) {
  var _ref$arrowDisplay = _ref.arrowDisplay,
    arrowDisplay = _ref$arrowDisplay === void 0 ? 'left' : _ref$arrowDisplay,
    arrowProps = _ref.arrowProps,
    isOpen = _ref.isOpen,
    rest = _objectWithoutProperties(_ref, _excluded);
  var euiTheme = (0, _services.useEuiTheme)();
  if (arrowDisplay === 'none') return null;
  var styles = (0, _accordion_arrow.euiAccordionArrowStyles)(euiTheme);
  var cssStyles = [styles.euiAccordion__arrow, styles[arrowDisplay], isOpen ? styles.isOpen : styles.isClosed, arrowProps === null || arrowProps === void 0 ? void 0 : arrowProps.css];
  var classes = (0, _classnames.default)('euiAccordion__arrow', arrowProps === null || arrowProps === void 0 ? void 0 : arrowProps.className);
  return (0, _react2.jsx)(_button.EuiButtonIcon, _extends({
    color: "text"
  }, arrowProps, rest, {
    className: classes,
    css: cssStyles,
    iconType: "arrowRight"
  }));
};
EuiAccordionArrow.propTypes = {
  isOpen: _propTypes.default.bool.isRequired
};