"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getTextParts = getTextParts;
const common_1 = require("../../../../utils/common");
const specs_1 = require("../../specs");
function getTextParts(datum, style) {
    const values = Array.isArray(datum.value) ? datum.value : [datum.value];
    const valueFormatter = (0, specs_1.isMetricWNumber)(datum) || (0, specs_1.isMetricWNumberArrayValues)(datum) ? datum.valueFormatter : (v) => `${v}`;
    const textParts = values.reduce((acc, value, i, { length }) => {
        const parts = typeof value === 'number'
            ? (0, common_1.isFiniteNumber)(value)
                ? splitNumericSuffixPrefix(valueFormatter(value))
                : [{ emphasis: 'normal', text: style.nonFiniteText }]
            : [{ emphasis: 'normal', text: value }];
        if (i < length - 1) {
            parts.push({ emphasis: 'normal', text: ', ' });
        }
        return [...acc, ...parts];
    }, []);
    if (!Array.isArray(datum.value))
        return textParts;
    return [{ emphasis: 'normal', text: '[' }, ...textParts, { emphasis: 'normal', text: ']' }];
}
function splitNumericSuffixPrefix(text) {
    return text
        .split('')
        .reduce((acc, curr) => {
        const emphasis = curr === '.' || curr === ',' || (0, common_1.isFiniteNumber)(Number.parseInt(curr)) ? 'normal' : 'small';
        if (acc.length > 0 && acc.at(-1)?.emphasis === emphasis) {
            acc.at(-1)?.textParts.push(curr);
        }
        else {
            acc.push({ emphasis, textParts: [curr] });
        }
        return acc;
    }, [])
        .map(({ emphasis, textParts }) => ({
        emphasis,
        text: textParts.join(''),
    }));
}
//# sourceMappingURL=text_processing.js.map