/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public enum AllocationDecision implements Writeable
{
    YES(0),
    THROTTLED(1),
    NO(2),
    WORSE_BALANCE(3),
    AWAITING_INFO(4),
    ALLOCATION_DELAYED(5),
    NO_VALID_SHARD_COPY(6),
    NO_ATTEMPT(7);

    private final byte id;

    private AllocationDecision(byte id) {
        this.id = id;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeByte(this.id);
    }

    public static AllocationDecision readFrom(StreamInput in) throws IOException {
        byte id = in.readByte();
        return switch (id) {
            case 0 -> YES;
            case 1 -> THROTTLED;
            case 2 -> NO;
            case 3 -> WORSE_BALANCE;
            case 4 -> AWAITING_INFO;
            case 5 -> ALLOCATION_DELAYED;
            case 6 -> NO_VALID_SHARD_COPY;
            case 7 -> NO_ATTEMPT;
            default -> throw new IllegalArgumentException("Unknown value [" + id + "]");
        };
    }

    public static AllocationDecision fromAllocationStatus(UnassignedInfo.AllocationStatus allocationStatus) {
        if (allocationStatus == null) {
            return YES;
        }
        return switch (allocationStatus) {
            default -> throw new MatchException(null, null);
            case UnassignedInfo.AllocationStatus.DECIDERS_THROTTLED -> THROTTLED;
            case UnassignedInfo.AllocationStatus.FETCHING_SHARD_DATA -> AWAITING_INFO;
            case UnassignedInfo.AllocationStatus.DELAYED_ALLOCATION -> ALLOCATION_DELAYED;
            case UnassignedInfo.AllocationStatus.NO_VALID_SHARD_COPY -> NO_VALID_SHARD_COPY;
            case UnassignedInfo.AllocationStatus.NO_ATTEMPT -> NO_ATTEMPT;
            case UnassignedInfo.AllocationStatus.DECIDERS_NO -> NO;
        };
    }

    public static AllocationDecision fromDecisionType(Decision.Type type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case Decision.Type.YES -> YES;
            case Decision.Type.THROTTLE -> THROTTLED;
            case Decision.Type.NO -> NO;
        };
    }

    public String toString() {
        return super.toString().toLowerCase(Locale.ROOT);
    }
}

