/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.querydsl.query;

import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.tree.Source;

public class MultiMatchQuery
extends Query {
    private static final Map<String, BiConsumer<MultiMatchQueryBuilder, Object>> BUILDER_APPLIERS = Map.ofEntries(Map.entry(MultiMatchQueryBuilder.BOOST_FIELD.getPreferredName(), (qb, obj) -> qb.boost(((Float)obj).floatValue())), Map.entry(MultiMatchQueryBuilder.SLOP_FIELD.getPreferredName(), (qb, obj) -> qb.slop(((Integer)obj).intValue())), Map.entry(MultiMatchQueryBuilder.ANALYZER_FIELD.getPreferredName(), (qb, obj) -> qb.analyzer((String)obj)), Map.entry(MultiMatchQueryBuilder.GENERATE_SYNONYMS_PHRASE_QUERY.getPreferredName(), (qb, obj) -> qb.autoGenerateSynonymsPhraseQuery(((Boolean)obj).booleanValue())), Map.entry(MultiMatchQueryBuilder.FUZZINESS_FIELD.getPreferredName(), (qb, obj) -> qb.fuzziness(Fuzziness.fromString((String)((String)obj)))), Map.entry(MultiMatchQueryBuilder.FUZZY_REWRITE_FIELD.getPreferredName(), (qb, obj) -> qb.fuzzyRewrite((String)obj)), Map.entry(MultiMatchQueryBuilder.FUZZY_TRANSPOSITIONS_FIELD.getPreferredName(), (qb, obj) -> qb.fuzzyTranspositions(((Boolean)obj).booleanValue())), Map.entry(MultiMatchQueryBuilder.LENIENT_FIELD.getPreferredName(), (qb, obj) -> qb.lenient(((Boolean)obj).booleanValue())), Map.entry(MultiMatchQueryBuilder.MAX_EXPANSIONS_FIELD.getPreferredName(), (qb, obj) -> qb.maxExpansions(((Integer)obj).intValue())), Map.entry(MultiMatchQueryBuilder.MINIMUM_SHOULD_MATCH_FIELD.getPreferredName(), (qb, obj) -> qb.minimumShouldMatch((String)obj)), Map.entry(MultiMatchQueryBuilder.OPERATOR_FIELD.getPreferredName(), (qb, obj) -> qb.operator(Operator.fromString((String)((String)obj)))), Map.entry(MultiMatchQueryBuilder.PREFIX_LENGTH_FIELD.getPreferredName(), (qb, obj) -> qb.prefixLength(((Integer)obj).intValue())), Map.entry(MultiMatchQueryBuilder.TIE_BREAKER_FIELD.getPreferredName(), (qb, obj) -> qb.tieBreaker((Float)obj)), Map.entry(MultiMatchQueryBuilder.TYPE_FIELD.getPreferredName(), (qb, obj) -> qb.type((Object)((String)obj))));
    private final String query;
    private final Map<String, Float> fields;
    private final Map<String, Object> options;

    public MultiMatchQuery(Source source, String query, Map<String, Float> fields, Map<String, Object> options) {
        super(source);
        this.query = query;
        this.fields = fields;
        this.options = options;
    }

    protected QueryBuilder asBuilder() {
        MultiMatchQueryBuilder queryBuilder = QueryBuilders.multiMatchQuery((Object)this.query, (String[])new String[0]);
        queryBuilder.fields(this.fields);
        this.options.forEach((k, v) -> {
            if (!BUILDER_APPLIERS.containsKey(k)) {
                throw new IllegalArgumentException("illegal multi_match option [" + k + "]");
            }
            BUILDER_APPLIERS.get(k).accept(queryBuilder, v);
        });
        return queryBuilder;
    }

    public int hashCode() {
        return Objects.hash(this.query, this.fields, this.options);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        MultiMatchQuery other = (MultiMatchQuery)((Object)obj);
        return Objects.equals(this.query, other.query) && Objects.equals(this.fields, other.fields) && Objects.equals(this.options, other.options);
    }

    protected String innerToString() {
        return String.valueOf(new TreeMap<String, Float>(this.fields)) + ":" + this.query;
    }

    public boolean scorable() {
        return true;
    }

    public boolean containsPlan() {
        return false;
    }
}

