/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.FunctionType;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.CountDistinct;
import org.elasticsearch.xpack.esql.expression.function.aggregate.TimeSeriesAggregateFunction;

public class CountDistinctOverTime
extends TimeSeriesAggregateFunction
implements OptionalArgument {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "DistinctOverTime", CountDistinctOverTime::new);
    private final Expression precision;

    @FunctionInfo(returnType={"long"}, description="The count of distinct values over time for a field.", type=FunctionType.AGGREGATE)
    public CountDistinctOverTime(Source source, @Param(name="field", type={"boolean", "date", "date_nanos", "double", "integer", "ip", "keyword", "long", "text", "version"}) Expression field, @Param(optional=true, name="precision", type={"integer", "long", "unsigned_long"}, description="Precision threshold. Refer to <<esql-agg-count-distinct-approximate>>. The maximum supported value is 40000. Thresholds above this number will have the same effect as a threshold of 40000. The default value is 3000.") Expression precision) {
        this(source, field, (Expression)Literal.TRUE, precision);
    }

    public CountDistinctOverTime(Source source, Expression field, Expression filter, Expression precision) {
        super(source, field, filter, precision == null ? List.of() : List.of(precision));
        this.precision = precision;
    }

    private CountDistinctOverTime(StreamInput in) throws IOException {
        super(in);
        this.precision = this.parameters().isEmpty() ? null : this.parameters().getFirst();
    }

    public String getWriteableName() {
        return CountDistinctOverTime.ENTRY.name;
    }

    @Override
    public CountDistinctOverTime withFilter(Expression filter) {
        return new CountDistinctOverTime(this.source(), this.field(), filter, this.precision);
    }

    protected NodeInfo<CountDistinctOverTime> info() {
        return NodeInfo.create((Node)this, CountDistinctOverTime::new, (Object)this.field(), (Object)this.filter(), (Object)this.precision);
    }

    public CountDistinctOverTime replaceChildren(List<Expression> newChildren) {
        if (newChildren.size() < 3) {
            return new CountDistinctOverTime(this.source(), newChildren.get(0), newChildren.get(1), null);
        }
        return new CountDistinctOverTime(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2));
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return this.perTimeSeriesAggregation().resolveType();
    }

    public DataType dataType() {
        return this.perTimeSeriesAggregation().dataType();
    }

    @Override
    public CountDistinct perTimeSeriesAggregation() {
        return new CountDistinct(this.source(), this.field(), this.filter(), this.precision);
    }
}

