/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.AbstractNonThreadSafeRefCounted;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockStreamInput;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefLookup;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.OrdinalBytesRefVector;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;
import org.elasticsearch.core.Releasables;

public final class OrdinalBytesRefBlock
extends AbstractNonThreadSafeRefCounted
implements BytesRefBlock {
    private final IntBlock ordinals;
    private final BytesRefVector bytes;

    public OrdinalBytesRefBlock(IntBlock ordinals, BytesRefVector bytes) {
        this.ordinals = ordinals;
        this.bytes = bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static OrdinalBytesRefBlock readOrdinalBlock(BlockFactory blockFactory, BlockStreamInput in) throws IOException {
        BytesRefVector bytes = null;
        OrdinalBytesRefBlock result = null;
        IntBlock ordinals = IntBlock.readFrom(in);
        try {
            bytes = BytesRefVector.readFrom(blockFactory, (StreamInput)in);
            result = new OrdinalBytesRefBlock(ordinals, bytes);
            if (result != null) return result;
        }
        catch (Throwable throwable) {
            if (result != null) throw throwable;
            Releasables.close((Releasable[])new Releasable[]{ordinals, bytes});
            throw throwable;
        }
        Releasables.close((Releasable[])new Releasable[]{ordinals, bytes});
        return result;
    }

    void writeOrdinalBlock(StreamOutput out) throws IOException {
        this.ordinals.writeTo(out);
        this.bytes.writeTo(out);
    }

    public boolean isDense() {
        return OrdinalBytesRefBlock.isDense(this.ordinals.getTotalValueCount(), this.bytes.getPositionCount());
    }

    public static boolean isDense(long totalPositions, long dictionarySize) {
        return totalPositions >= 10L && totalPositions >= dictionarySize * 2L;
    }

    public IntBlock getOrdinalsBlock() {
        return this.ordinals;
    }

    public BytesRefVector getDictionaryVector() {
        return this.bytes;
    }

    @Override
    public BytesRef getBytesRef(int valueIndex, BytesRef dest) {
        return this.bytes.getBytesRef(this.ordinals.getInt(valueIndex), dest);
    }

    @Override
    public OrdinalBytesRefVector asVector() {
        IntVector vector = this.ordinals.asVector();
        if (vector != null) {
            return new OrdinalBytesRefVector(vector, this.bytes);
        }
        return null;
    }

    @Override
    public OrdinalBytesRefBlock asOrdinals() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BytesRefBlock filter(int ... positions) {
        if (positions.length * this.ordinals.getTotalValueCount() >= this.bytes.getPositionCount() * this.ordinals.getPositionCount()) {
            OrdinalBytesRefBlock result = null;
            IntBlock filteredOrdinals = this.ordinals.filter(positions);
            try {
                result = new OrdinalBytesRefBlock(filteredOrdinals, this.bytes);
                this.bytes.incRef();
            }
            finally {
                if (result == null) {
                    filteredOrdinals.close();
                }
            }
            return result;
        }
        BytesRef scratch = new BytesRef();
        try (BytesRefBlock.Builder builder = this.blockFactory().newBytesRefBlockBuilder(positions.length);){
            for (int pos : positions) {
                if (this.isNull(pos)) {
                    builder.appendNull();
                    continue;
                }
                int valueCount = this.getValueCount(pos);
                int first = this.getFirstValueIndex(pos);
                if (valueCount == 1) {
                    builder.appendBytesRef(this.getBytesRef(this.getFirstValueIndex(pos), scratch));
                    continue;
                }
                builder.beginPositionEntry();
                for (int c = 0; c < valueCount; ++c) {
                    builder.appendBytesRef(this.getBytesRef(first + c, scratch));
                }
                builder.endPositionEntry();
            }
            BytesRefBlock bytesRefBlock = builder.mvOrdering(this.mvOrdering()).build();
            return bytesRefBlock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BytesRefBlock keepMask(BooleanVector mask) {
        if (this.getPositionCount() == 0) {
            this.incRef();
            return this;
        }
        if (mask.isConstant()) {
            if (mask.getBoolean(0)) {
                this.incRef();
                return this;
            }
            return (BytesRefBlock)this.blockFactory().newConstantNullBlock(this.getPositionCount());
        }
        OrdinalBytesRefBlock result = null;
        IntBlock filteredOrdinals = this.ordinals.keepMask(mask);
        try {
            result = new OrdinalBytesRefBlock(filteredOrdinals, this.bytes);
            this.bytes.incRef();
        }
        finally {
            if (result == null) {
                filteredOrdinals.close();
            }
        }
        return result;
    }

    public ReleasableIterator<BytesRefBlock> lookup(IntBlock positions, ByteSizeValue targetBlockSize) {
        return new BytesRefLookup(this, positions, targetBlockSize);
    }

    @Override
    protected void closeInternal() {
        Releasables.close((Releasable[])new Releasable[]{this.ordinals, this.bytes});
    }

    @Override
    public int getTotalValueCount() {
        return this.ordinals.getTotalValueCount();
    }

    @Override
    public int getPositionCount() {
        return this.ordinals.getPositionCount();
    }

    @Override
    public int getFirstValueIndex(int position) {
        return this.ordinals.getFirstValueIndex(position);
    }

    @Override
    public int getValueCount(int position) {
        return this.ordinals.getValueCount(position);
    }

    @Override
    public ElementType elementType() {
        return this.bytes.elementType();
    }

    @Override
    public BlockFactory blockFactory() {
        return this.ordinals.blockFactory();
    }

    @Override
    public void allowPassingToDifferentDriver() {
        this.ordinals.allowPassingToDifferentDriver();
        this.bytes.allowPassingToDifferentDriver();
    }

    @Override
    public boolean isNull(int position) {
        return this.ordinals.isNull(position);
    }

    @Override
    public boolean mayHaveNulls() {
        return this.ordinals.mayHaveNulls();
    }

    @Override
    public boolean areAllValuesNull() {
        return this.ordinals.areAllValuesNull();
    }

    @Override
    public boolean mayHaveMultivaluedFields() {
        return this.ordinals.mayHaveMultivaluedFields();
    }

    @Override
    public boolean doesHaveMultivaluedFields() {
        return this.ordinals.mayHaveMultivaluedFields();
    }

    @Override
    public Block.MvOrdering mvOrdering() {
        return this.ordinals.mvOrdering();
    }

    @Override
    public OrdinalBytesRefBlock expand() {
        OrdinalBytesRefBlock result = null;
        IntBlock expandedOrdinals = this.ordinals.expand();
        try {
            result = new OrdinalBytesRefBlock(expandedOrdinals, this.bytes);
            this.bytes.incRef();
        }
        finally {
            if (result == null) {
                expandedOrdinals.close();
            }
        }
        return result;
    }

    public long ramBytesUsed() {
        return this.ordinals.ramBytesUsed() + this.bytes.ramBytesUsed();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof BytesRefBlock) {
            BytesRefBlock b = (BytesRefBlock)o;
            return BytesRefBlock.equals(this, b);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return BytesRefBlock.hash(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[ordinals=" + String.valueOf(this.ordinals) + ", bytes=" + String.valueOf(this.bytes) + "]";
    }
}

