/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.geoip;

import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.ingest.EnterpriseGeoIpTask;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseStateListener;
import org.elasticsearch.license.LicensedFeature;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteTransportException;

public class EnterpriseGeoIpDownloaderLicenseListener
implements LicenseStateListener,
ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(EnterpriseGeoIpDownloaderLicenseListener.class);
    static final String INGEST_GEOIP_CUSTOM_METADATA_TYPE = "ingest_geoip";
    private final PersistentTasksService persistentTasksService;
    private final ClusterService clusterService;
    private final XPackLicenseState licenseState;
    private static final LicensedFeature.Momentary ENTERPRISE_GEOIP_FEATURE = LicensedFeature.momentary(null, (String)"enterprise_geoip_downloader", (License.OperationMode)License.OperationMode.PLATINUM);
    private volatile boolean licenseIsValid = false;
    private volatile boolean hasIngestGeoIpMetadata = false;
    private volatile boolean licenseStateListenerRegistered;

    protected EnterpriseGeoIpDownloaderLicenseListener(Client client, ClusterService clusterService, ThreadPool threadPool, XPackLicenseState licenseState) {
        this.persistentTasksService = new PersistentTasksService(clusterService, threadPool, client);
        this.clusterService = clusterService;
        this.licenseState = licenseState;
    }

    public void init() {
        this.listenForLicenseStateChanges();
        this.clusterService.addListener((ClusterStateListener)this);
    }

    void listenForLicenseStateChanges() {
        assert (!this.licenseStateListenerRegistered) : "listenForLicenseStateChanges() should only be called once";
        this.licenseStateListenerRegistered = true;
        this.licenseState.addListener((LicenseStateListener)this);
    }

    public void licenseStateChanged() {
        this.licenseIsValid = ENTERPRISE_GEOIP_FEATURE.checkWithoutTracking(this.licenseState);
        this.maybeUpdateTaskState(this.clusterService.state());
    }

    public void clusterChanged(ClusterChangedEvent event) {
        boolean masterNodeChanged;
        this.hasIngestGeoIpMetadata = event.state().metadata().getProject().custom(INGEST_GEOIP_CUSTOM_METADATA_TYPE) != null;
        boolean ingestGeoIpCustomMetaChangedInEvent = event.metadataChanged() && event.changedCustomProjectMetadataSet().contains(INGEST_GEOIP_CUSTOM_METADATA_TYPE);
        boolean bl = masterNodeChanged = !Objects.equals(event.state().nodes().getMasterNode(), event.previousState().nodes().getMasterNode());
        if (ingestGeoIpCustomMetaChangedInEvent || masterNodeChanged && this.hasIngestGeoIpMetadata) {
            this.maybeUpdateTaskState(event.state());
        }
    }

    private void maybeUpdateTaskState(ClusterState state) {
        if (state.nodes().isLocalNodeElectedMaster()) {
            if (this.licenseIsValid) {
                if (this.hasIngestGeoIpMetadata) {
                    this.ensureTaskStarted();
                }
            } else {
                this.ensureTaskStopped();
            }
        }
    }

    private void ensureTaskStarted() {
        assert (this.licenseIsValid) : "Task should never be started without valid license";
        this.persistentTasksService.sendStartRequest("enterprise-geoip-downloader", "enterprise-geoip-downloader", (PersistentTaskParams)new EnterpriseGeoIpTask.EnterpriseGeoIpTaskParams(), MasterNodeRequest.INFINITE_MASTER_NODE_TIMEOUT, ActionListener.wrap(r -> logger.debug("Started enterprise geoip downloader task"), e -> {
            Throwable t;
            Throwable throwable = t = e instanceof RemoteTransportException ? ExceptionsHelper.unwrapCause((Throwable)e) : e;
            if (!(t instanceof ResourceAlreadyExistsException)) {
                logger.error("failed to create enterprise geoip downloader task", (Throwable)e);
            }
        }));
    }

    private void ensureTaskStopped() {
        ActionListener listener = ActionListener.wrap(r -> logger.debug("Stopped enterprise geoip downloader task"), e -> {
            Throwable t;
            Throwable throwable = t = e instanceof RemoteTransportException ? ExceptionsHelper.unwrapCause((Throwable)e) : e;
            if (!(t instanceof ResourceNotFoundException)) {
                logger.error("failed to remove enterprise geoip downloader task", (Throwable)e);
            }
        });
        this.persistentTasksService.sendRemoveRequest("enterprise-geoip-downloader", MasterNodeRequest.INFINITE_MASTER_NODE_TIMEOUT, listener);
    }
}

