/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.shutdown;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.shutdown.PutShutdownNodeAction;

public class RestPutShutdownNodeAction
extends BaseRestHandler {
    public String getName() {
        return "put_shutdown_node";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, "/_nodes/{nodeId}/shutdown"));
    }

    public boolean canTripCircuitBreaker() {
        return false;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        PutShutdownNodeAction.Request parsedRequest = this.parseRequest(request);
        return channel -> client.execute((ActionType)PutShutdownNodeAction.INSTANCE, (ActionRequest)parsedRequest, (ActionListener)new RestToXContentListener(channel));
    }

    private PutShutdownNodeAction.Request parseRequest(RestRequest restRequest) throws IOException {
        try (XContentParser parser = restRequest.contentParser();){
            PutShutdownNodeAction.Request request = PutShutdownNodeAction.Request.parseRequest(new RestRequestFactory(restRequest), parser);
            return request;
        }
    }

    private static class RestRequestFactory
    implements PutShutdownNodeAction.Request.Factory {
        private final String nodeId;
        private final TimeValue masterNodeTimeout;
        private final TimeValue ackTimeout;

        RestRequestFactory(RestRequest restRequest) {
            this.nodeId = restRequest.param("nodeId");
            this.masterNodeTimeout = RestUtils.getMasterNodeTimeout((RestRequest)restRequest);
            this.ackTimeout = RestUtils.getAckTimeout((RestRequest)restRequest);
        }

        @Override
        public PutShutdownNodeAction.Request create(SingleNodeShutdownMetadata.Type type, String reason, TimeValue allocationDelay, String targetNodeName, TimeValue gracePeriod) {
            return new PutShutdownNodeAction.Request(this.masterNodeTimeout, this.ackTimeout, this.nodeId, type, reason, allocationDelay, targetNodeName, gracePeriod);
        }

        public String toString() {
            return "put-shutdown-node-request-" + this.nodeId;
        }
    }
}

