/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.inference;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.action.StartTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.action.UpdateTrainedModelDeploymentAction;

@ServerlessScope(value=Scope.PUBLIC)
public class RestUpdateTrainedModelDeploymentAction
extends BaseRestHandler {
    public String getName() {
        return "xpack_ml_update_trained_model_deployment_action";
    }

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.POST, "/_ml/trained_models/{" + StartTrainedModelDeploymentAction.Request.MODEL_ID.getPreferredName() + "}/deployment/_update"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        UpdateTrainedModelDeploymentAction.Request request;
        String modelId = restRequest.param(StartTrainedModelDeploymentAction.Request.MODEL_ID.getPreferredName());
        if (restRequest.hasParam(StartTrainedModelDeploymentAction.Request.NUMBER_OF_ALLOCATIONS.getPreferredName())) {
            int numberOfAllocations = restRequest.paramAsInt(StartTrainedModelDeploymentAction.Request.NUMBER_OF_ALLOCATIONS.getPreferredName(), 0);
            request = new UpdateTrainedModelDeploymentAction.Request(modelId);
            request.setNumberOfAllocations(Integer.valueOf(numberOfAllocations));
        } else {
            XContentParser parser = restRequest.contentParser();
            request = UpdateTrainedModelDeploymentAction.Request.parseRequest((String)modelId, (XContentParser)parser);
        }
        request.ackTimeout(RestUtils.getAckTimeout((RestRequest)restRequest));
        request.masterNodeTimeout(RestUtils.getMasterNodeTimeout((RestRequest)restRequest));
        return channel -> client.execute((ActionType)UpdateTrainedModelDeploymentAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

