/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.license.License;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.esql.LicenseAware;
import org.elasticsearch.xpack.esql.capabilities.PostAnalysisVerificationAware;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.plan.logical.Fork;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;

public class RrfScoreEval
extends UnaryPlan
implements PostAnalysisVerificationAware,
LicenseAware {
    private final Attribute forkAttr;
    private final Attribute scoreAttr;

    public RrfScoreEval(Source source, LogicalPlan child, Attribute scoreAttr, Attribute forkAttr) {
        super(source, child);
        this.scoreAttr = scoreAttr;
        this.forkAttr = forkAttr;
    }

    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("not serialized");
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException("not serialized");
    }

    protected NodeInfo<? extends LogicalPlan> info() {
        return NodeInfo.create((Node)this, RrfScoreEval::new, (Object)((Object)this.child()), (Object)this.scoreAttr, (Object)this.forkAttr);
    }

    @Override
    public boolean expressionsResolved() {
        return this.scoreAttr.resolved() && this.forkAttr.resolved();
    }

    @Override
    public UnaryPlan replaceChild(LogicalPlan newChild) {
        return new RrfScoreEval(this.source(), newChild, this.scoreAttr, this.forkAttr);
    }

    public Attribute scoreAttribute() {
        return this.scoreAttr;
    }

    public Attribute forkAttribute() {
        return this.forkAttr;
    }

    @Override
    public void postAnalysisVerification(Failures failures) {
        if (!(this.child() instanceof Fork)) {
            failures.add(Failure.fail(this, "Invalid use of RRF. RRF can only be used after FORK, but found {}", this.child().sourceText().split(" ")[0].toUpperCase(Locale.ROOT)));
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.scoreAttr, this.forkAttr);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RrfScoreEval rrf = (RrfScoreEval)obj;
        return this.child().equals((Object)rrf.child()) && this.scoreAttr.equals((Object)rrf.scoreAttribute()) && this.forkAttr.equals((Object)this.forkAttribute());
    }

    @Override
    public boolean licenseCheck(XPackLicenseState state) {
        return state.isAllowedByLicense(License.OperationMode.ENTERPRISE);
    }
}

