/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip.direct;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.ingest.geoip.DatabaseNodeService;
import org.elasticsearch.ingest.geoip.GeoIpTaskState;
import org.elasticsearch.ingest.geoip.IngestGeoIpMetadata;
import org.elasticsearch.ingest.geoip.direct.DatabaseConfiguration;
import org.elasticsearch.ingest.geoip.direct.DatabaseConfigurationMetadata;
import org.elasticsearch.ingest.geoip.direct.GetDatabaseConfigurationAction;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetDatabaseConfigurationAction
extends TransportNodesAction<GetDatabaseConfigurationAction.Request, GetDatabaseConfigurationAction.Response, GetDatabaseConfigurationAction.NodeRequest, GetDatabaseConfigurationAction.NodeResponse, List<DatabaseConfigurationMetadata>> {
    private final DatabaseNodeService databaseNodeService;

    @Inject
    public TransportGetDatabaseConfigurationAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, DatabaseNodeService databaseNodeService) {
        super("cluster:admin/ingest/geoip/database/get", clusterService, transportService, actionFilters, GetDatabaseConfigurationAction.NodeRequest::new, (Executor)threadPool.executor("management"));
        this.databaseNodeService = databaseNodeService;
    }

    protected List<DatabaseConfigurationMetadata> createActionContext(Task task, GetDatabaseConfigurationAction.Request request) {
        Set<String> ids = request.getDatabaseIds().length == 0 ? Set.of("*") : new LinkedHashSet<String>(Arrays.asList(request.getDatabaseIds()));
        if (ids.size() > 1 && ids.stream().anyMatch(Regex::isSimpleMatchPattern)) {
            throw new IllegalArgumentException("wildcard only supports a single value, please use comma-separated values or a single wildcard value");
        }
        ArrayList<DatabaseConfigurationMetadata> results = new ArrayList<DatabaseConfigurationMetadata>();
        PersistentTasksCustomMetadata tasksMetadata = PersistentTasksCustomMetadata.getPersistentTasksCustomMetadata((ClusterState)this.clusterService.state());
        for (String id : ids) {
            results.addAll(TransportGetDatabaseConfigurationAction.getWebDatabases(tasksMetadata, id));
            results.addAll(TransportGetDatabaseConfigurationAction.getMaxmindDatabases(this.clusterService, id));
        }
        return results;
    }

    private static Collection<DatabaseConfigurationMetadata> getWebDatabases(PersistentTasksCustomMetadata tasksMetadata, String id) {
        GeoIpTaskState geoIpTaskState;
        PersistentTasksCustomMetadata.PersistentTask maybeGeoIpTask;
        ArrayList<DatabaseConfigurationMetadata> webDatabases = new ArrayList<DatabaseConfigurationMetadata>();
        if (tasksMetadata != null && (maybeGeoIpTask = tasksMetadata.getTask("geoip-downloader")) != null && (geoIpTaskState = (GeoIpTaskState)maybeGeoIpTask.getState()) != null) {
            Map<String, GeoIpTaskState.Metadata> databases = geoIpTaskState.getDatabases();
            for (String databaseFileName : databases.keySet()) {
                String databaseName = TransportGetDatabaseConfigurationAction.getDatabaseNameForFileName(databaseFileName);
                String databaseId = TransportGetDatabaseConfigurationAction.getDatabaseIdForFileName("web", databaseFileName);
                if ((!Regex.isSimpleMatchPattern((String)id) || !Regex.simpleMatch((String)id, (String)databaseId)) && !id.equals(databaseId)) continue;
                webDatabases.add(new DatabaseConfigurationMetadata(new DatabaseConfiguration(databaseId, databaseName, new DatabaseConfiguration.Web()), -1L, databases.get(databaseFileName).lastUpdate()));
            }
        }
        return webDatabases;
    }

    private static String getDatabaseIdForFileName(String providerType, String databaseFileName) {
        return "_" + providerType + "_" + Base64.getEncoder().encodeToString(databaseFileName.getBytes(StandardCharsets.UTF_8));
    }

    private static String getDatabaseNameForFileName(String databaseFileName) {
        return databaseFileName.endsWith(".mmdb") ? databaseFileName.substring(0, databaseFileName.length() + 1 - ".mmmdb".length()) : databaseFileName;
    }

    private static Collection<DatabaseConfigurationMetadata> getMaxmindDatabases(ClusterService clusterService, String id) {
        ArrayList<DatabaseConfigurationMetadata> maxmindDatabases = new ArrayList<DatabaseConfigurationMetadata>();
        IngestGeoIpMetadata geoIpMeta = (IngestGeoIpMetadata)clusterService.state().metadata().getProject().custom("ingest_geoip", (Metadata.ProjectCustom)IngestGeoIpMetadata.EMPTY);
        if (Regex.isSimpleMatchPattern((String)id)) {
            for (Map.Entry<String, DatabaseConfigurationMetadata> entry : geoIpMeta.getDatabases().entrySet()) {
                if (!Regex.simpleMatch((String)id, (String)entry.getKey())) continue;
                maxmindDatabases.add(entry.getValue());
            }
        } else {
            DatabaseConfigurationMetadata meta = geoIpMeta.getDatabases().get(id);
            if (meta != null) {
                maxmindDatabases.add(meta);
            }
        }
        return maxmindDatabases;
    }

    protected void newResponseAsync(Task task, GetDatabaseConfigurationAction.Request request, List<DatabaseConfigurationMetadata> results, List<GetDatabaseConfigurationAction.NodeResponse> responses, List<FailedNodeException> failures, ActionListener<GetDatabaseConfigurationAction.Response> listener) {
        ActionListener.run(listener, l -> {
            ArrayList<DatabaseConfigurationMetadata> combinedResults = new ArrayList<DatabaseConfigurationMetadata>(results);
            combinedResults.addAll(TransportGetDatabaseConfigurationAction.deduplicateNodeResponses(responses, results.stream().map(result -> result.database().name()).collect(Collectors.toSet())));
            ActionListener.respondAndRelease((ActionListener)l, (RefCounted)new GetDatabaseConfigurationAction.Response(combinedResults, this.clusterService.getClusterName(), responses, failures));
        });
    }

    static Collection<DatabaseConfigurationMetadata> deduplicateNodeResponses(List<GetDatabaseConfigurationAction.NodeResponse> nodeResponses, Set<String> preExistingNames) {
        return nodeResponses.stream().flatMap(response -> response.getDatabases().stream()).collect(Collectors.groupingBy(database -> database.database().name(), Collectors.maxBy(Comparator.comparing(DatabaseConfigurationMetadata::modifiedDate)))).values().stream().filter(Optional::isPresent).map(Optional::get).filter(database -> !preExistingNames.contains(database.database().name())).toList();
    }

    protected GetDatabaseConfigurationAction.Response newResponse(GetDatabaseConfigurationAction.Request request, List<GetDatabaseConfigurationAction.NodeResponse> nodeResponses, List<FailedNodeException> failures) {
        throw new UnsupportedOperationException("Use newResponseAsync instead");
    }

    protected GetDatabaseConfigurationAction.NodeRequest newNodeRequest(GetDatabaseConfigurationAction.Request request) {
        return new GetDatabaseConfigurationAction.NodeRequest(request.getDatabaseIds());
    }

    protected GetDatabaseConfigurationAction.NodeResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new GetDatabaseConfigurationAction.NodeResponse(in);
    }

    protected GetDatabaseConfigurationAction.NodeResponse nodeOperation(GetDatabaseConfigurationAction.NodeRequest request, Task task) {
        Set<String> ids = request.getDatabaseIds().length == 0 ? Set.of("*") : new LinkedHashSet<String>(Arrays.asList(request.getDatabaseIds()));
        if (ids.size() > 1 && ids.stream().anyMatch(Regex::isSimpleMatchPattern)) {
            throw new IllegalArgumentException("wildcard only supports a single value, please use comma-separated values or a single wildcard value");
        }
        ArrayList<DatabaseConfigurationMetadata> results = new ArrayList<DatabaseConfigurationMetadata>();
        for (String id : ids) {
            results.addAll(TransportGetDatabaseConfigurationAction.getLocalDatabases(this.databaseNodeService, id));
        }
        return new GetDatabaseConfigurationAction.NodeResponse(this.transportService.getLocalNode(), results);
    }

    private static List<DatabaseConfigurationMetadata> getLocalDatabases(DatabaseNodeService databaseNodeService, String id) {
        ArrayList<DatabaseConfigurationMetadata> localDatabases = new ArrayList<DatabaseConfigurationMetadata>();
        Map<String, DatabaseNodeService.ConfigDatabaseDetail> configDatabases = databaseNodeService.getConfigDatabasesDetail();
        for (DatabaseNodeService.ConfigDatabaseDetail configDatabase : configDatabases.values()) {
            String databaseId = TransportGetDatabaseConfigurationAction.getDatabaseIdForFileName("local", configDatabase.name());
            if ((!Regex.isSimpleMatchPattern((String)id) || !Regex.simpleMatch((String)id, (String)databaseId)) && !id.equals(databaseId)) continue;
            localDatabases.add(new DatabaseConfigurationMetadata(new DatabaseConfiguration(databaseId, TransportGetDatabaseConfigurationAction.getDatabaseNameForFileName(configDatabase.name()), new DatabaseConfiguration.Local(configDatabase.type())), -1L, configDatabase.buildDateInMillis() == null ? -1L : configDatabase.buildDateInMillis()));
        }
        return localDatabases;
    }
}

