/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Scorable;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.lucene.ScorerAware;
import org.elasticsearch.script.DocBasedScript;
import org.elasticsearch.script.DocReader;
import org.elasticsearch.script.DocValuesDocReader;
import org.elasticsearch.script.DynamicMap;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptFactory;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.Source;

public abstract class AggregationScript
extends DocBasedScript
implements ScorerAware {
    public static final String[] PARAMETERS = new String[0];
    public static final ScriptContext<Factory> CONTEXT = new ScriptContext<Factory>("aggs", Factory.class);
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(DynamicMap.class);
    private static final Map<String, Function<Object, Object>> PARAMS_FUNCTIONS = Map.of("doc", value -> {
        deprecationLogger.warn(DeprecationCategory.SCRIPTING, "aggregation-script_doc", "Accessing variable [doc] via [params.doc] from within an aggregation-script is deprecated in favor of directly accessing [doc].", new Object[0]);
        return value;
    }, "_doc", value -> {
        deprecationLogger.warn(DeprecationCategory.SCRIPTING, "aggregation-script__doc", "Accessing variable [doc] via [params._doc] from within an aggregation-script is deprecated in favor of directly accessing [doc].", new Object[0]);
        return value;
    }, "_source", value -> ((Source)((Supplier)value).get()).source());
    private final Map<String, Object> params;
    protected Scorable scorer;
    private Object value;

    public AggregationScript(Map<String, Object> params, SearchLookup lookup, LeafReaderContext leafContext) {
        this(params, new DocValuesDocReader(lookup, leafContext));
    }

    private AggregationScript(Map<String, Object> params, DocReader docReader) {
        super(docReader);
        this.params = new DynamicMap(new HashMap<String, Object>(params), PARAMS_FUNCTIONS);
        this.params.putAll(docReader.docAsMap());
    }

    protected AggregationScript() {
        super(null);
        this.params = null;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    @Override
    public void setScorer(Scorable scorer) {
        this.scorer = scorer;
    }

    public void setNextAggregationValue(Object value) {
        this.value = value;
    }

    public Number get_score() {
        try {
            return this.scorer == null ? 0.0 : (double)this.scorer.score();
        }
        catch (IOException e) {
            throw new ElasticsearchException("couldn't lookup score", (Throwable)e, new Object[0]);
        }
    }

    public Object get_value() {
        return this.value;
    }

    public long runAsLong() {
        return ((Number)this.execute()).longValue();
    }

    public double runAsDouble() {
        return ((Number)this.execute()).doubleValue();
    }

    public abstract Object execute();

    public static interface Factory
    extends ScriptFactory {
        public LeafFactory newFactory(Map<String, Object> var1, SearchLookup var2);
    }

    public static interface LeafFactory {
        public AggregationScript newInstance(LeafReaderContext var1) throws IOException;

        public boolean needs_score();
    }
}

