/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import org.elasticsearch.cluster.routing.allocation.AllocateUnassignedDecision;
import org.elasticsearch.cluster.routing.allocation.MoveDecision;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.xcontent.ToXContent;

public final class ShardAllocationDecision
implements ChunkedToXContentObject,
Writeable {
    public static final ShardAllocationDecision NOT_TAKEN = new ShardAllocationDecision(AllocateUnassignedDecision.NOT_TAKEN, MoveDecision.NOT_TAKEN);
    private final AllocateUnassignedDecision allocateDecision;
    private final MoveDecision moveDecision;

    public ShardAllocationDecision(AllocateUnassignedDecision allocateDecision, MoveDecision moveDecision) {
        this.allocateDecision = allocateDecision;
        this.moveDecision = moveDecision;
    }

    public ShardAllocationDecision(StreamInput in) throws IOException {
        this.allocateDecision = new AllocateUnassignedDecision(in);
        this.moveDecision = new MoveDecision(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.allocateDecision.writeTo(out);
        this.moveDecision.writeTo(out);
    }

    public boolean isDecisionTaken() {
        return this.allocateDecision.isDecisionTaken() || this.moveDecision.isDecisionTaken();
    }

    public AllocateUnassignedDecision getAllocateDecision() {
        return this.allocateDecision;
    }

    public MoveDecision getMoveDecision() {
        return this.moveDecision;
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return Iterators.concat(this.allocateDecision.isDecisionTaken() ? this.allocateDecision.toXContentChunked(params) : Collections.emptyIterator(), this.moveDecision.isDecisionTaken() ? this.moveDecision.toXContentChunked(params) : Collections.emptyIterator());
    }
}

