/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast.java_signature;

import org.jruby.ast.java_signature.TypeNode;

public class ParameterNode {
    private final TypeNode type;
    private final String variableName;
    private boolean isFinal = false;
    private boolean isVarArgs = false;

    public ParameterNode(TypeNode type2, String variableName) {
        this.type = type2;
        this.variableName = variableName;
    }

    public ParameterNode(TypeNode type2, String variableName, boolean isFinal) {
        this(type2, variableName);
        this.isFinal = isFinal;
    }

    public ParameterNode(TypeNode type2, String variableName, boolean isFinal, boolean isVarArgs) {
        this(type2, variableName, isFinal);
        this.isVarArgs = isVarArgs;
    }

    public TypeNode getType() {
        return this.type;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public boolean isVarArgs() {
        return this.isVarArgs;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.isFinal) {
            builder.append("final ");
        }
        builder.append(this.type);
        if (this.isVarArgs()) {
            builder.append("...");
        }
        if (this.variableName != null) {
            builder.append(" ").append(this.variableName);
        }
        return builder.toString();
    }
}

