"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedSearchURLConflictCallout = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/saved-search-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const SavedSearchURLConflictCallout = ({
  savedSearch,
  spaces,
  history
}) => {
  var _savedSearch$sharingS;
  if (spaces && savedSearch !== null && savedSearch !== void 0 && savedSearch.id && (savedSearch === null || savedSearch === void 0 ? void 0 : (_savedSearch$sharingS = savedSearch.sharingSavedObjectProps) === null || _savedSearch$sharingS === void 0 ? void 0 : _savedSearch$sharingS.outcome) === 'conflict') {
    var _savedSearch$sharingS2;
    const otherObjectId = (_savedSearch$sharingS2 = savedSearch.sharingSavedObjectProps) === null || _savedSearch$sharingS2 === void 0 ? void 0 : _savedSearch$sharingS2.aliasTargetId;
    if (otherObjectId) {
      return spaces.ui.components.getLegacyUrlConflict({
        objectNoun: _i18n.i18n.translate('discover.savedSearchURLConflictCallout.objectNoun', {
          defaultMessage: `''{savedSearch}'' Discover session`,
          values: {
            savedSearch: savedSearch.title
          }
        }),
        currentObjectId: savedSearch.id,
        otherObjectPath: `${(0, _public.getSavedSearchUrl)(otherObjectId)}${history.location.search}`,
        otherObjectId
      });
    }
  }
  return null;
};
exports.SavedSearchURLConflictCallout = SavedSearchURLConflictCallout;